/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprServiceBindMetadata;
import java.io.IOException;

public final class DaprComponentServiceBinding
implements JsonSerializable<DaprComponentServiceBinding> {
    private String name;
    private String serviceId;
    private DaprServiceBindMetadata metadata;

    public String name() {
        return this.name;
    }

    public DaprComponentServiceBinding withName(String name) {
        this.name = name;
        return this;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public DaprComponentServiceBinding withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public DaprServiceBindMetadata metadata() {
        return this.metadata;
    }

    public DaprComponentServiceBinding withMetadata(DaprServiceBindMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("serviceId", this.serviceId);
        jsonWriter.writeJsonField("metadata", (JsonSerializable)this.metadata);
        return jsonWriter.writeEndObject();
    }

    public static DaprComponentServiceBinding fromJson(JsonReader jsonReader) throws IOException {
        return (DaprComponentServiceBinding)jsonReader.readObject(reader -> {
            DaprComponentServiceBinding deserializedDaprComponentServiceBinding = new DaprComponentServiceBinding();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDaprComponentServiceBinding.name = reader.getString();
                    continue;
                }
                if ("serviceId".equals(fieldName)) {
                    deserializedDaprComponentServiceBinding.serviceId = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedDaprComponentServiceBinding.metadata = DaprServiceBindMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprComponentServiceBinding;
        });
    }
}

