/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DaprAppHealth
implements JsonSerializable<DaprAppHealth> {
    private Boolean enabled;
    private String path;
    private Integer probeIntervalSeconds;
    private Integer probeTimeoutMilliseconds;
    private Integer threshold;

    public Boolean enabled() {
        return this.enabled;
    }

    public DaprAppHealth withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String path() {
        return this.path;
    }

    public DaprAppHealth withPath(String path) {
        this.path = path;
        return this;
    }

    public Integer probeIntervalSeconds() {
        return this.probeIntervalSeconds;
    }

    public DaprAppHealth withProbeIntervalSeconds(Integer probeIntervalSeconds) {
        this.probeIntervalSeconds = probeIntervalSeconds;
        return this;
    }

    public Integer probeTimeoutMilliseconds() {
        return this.probeTimeoutMilliseconds;
    }

    public DaprAppHealth withProbeTimeoutMilliseconds(Integer probeTimeoutMilliseconds) {
        this.probeTimeoutMilliseconds = probeTimeoutMilliseconds;
        return this;
    }

    public Integer threshold() {
        return this.threshold;
    }

    public DaprAppHealth withThreshold(Integer threshold) {
        this.threshold = threshold;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeNumberField("probeIntervalSeconds", (Number)this.probeIntervalSeconds);
        jsonWriter.writeNumberField("probeTimeoutMilliseconds", (Number)this.probeTimeoutMilliseconds);
        jsonWriter.writeNumberField("threshold", (Number)this.threshold);
        return jsonWriter.writeEndObject();
    }

    public static DaprAppHealth fromJson(JsonReader jsonReader) throws IOException {
        return (DaprAppHealth)jsonReader.readObject(reader -> {
            DaprAppHealth deserializedDaprAppHealth = new DaprAppHealth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedDaprAppHealth.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedDaprAppHealth.path = reader.getString();
                    continue;
                }
                if ("probeIntervalSeconds".equals(fieldName)) {
                    deserializedDaprAppHealth.probeIntervalSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("probeTimeoutMilliseconds".equals(fieldName)) {
                    deserializedDaprAppHealth.probeTimeoutMilliseconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedDaprAppHealth.threshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprAppHealth;
        });
    }
}

