/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CertificateKeyVaultProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CustomDomainConfiguration
implements JsonSerializable<CustomDomainConfiguration> {
    private String customDomainVerificationId;
    private String dnsSuffix;
    private CertificateKeyVaultProperties certificateKeyVaultProperties;
    private byte[] certificateValue;
    private String certificatePassword;
    private OffsetDateTime expirationDate;
    private String thumbprint;
    private String subjectName;

    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public CustomDomainConfiguration withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public CertificateKeyVaultProperties certificateKeyVaultProperties() {
        return this.certificateKeyVaultProperties;
    }

    public CustomDomainConfiguration withCertificateKeyVaultProperties(CertificateKeyVaultProperties certificateKeyVaultProperties) {
        this.certificateKeyVaultProperties = certificateKeyVaultProperties;
        return this;
    }

    public byte[] certificateValue() {
        return CoreUtils.clone((byte[])this.certificateValue);
    }

    public CustomDomainConfiguration withCertificateValue(byte[] certificateValue) {
        this.certificateValue = CoreUtils.clone((byte[])certificateValue);
        return this;
    }

    public String certificatePassword() {
        return this.certificatePassword;
    }

    public CustomDomainConfiguration withCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public void validate() {
        if (this.certificateKeyVaultProperties() != null) {
            this.certificateKeyVaultProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dnsSuffix", this.dnsSuffix);
        jsonWriter.writeJsonField("certificateKeyVaultProperties", (JsonSerializable)this.certificateKeyVaultProperties);
        jsonWriter.writeBinaryField("certificateValue", this.certificateValue);
        jsonWriter.writeStringField("certificatePassword", this.certificatePassword);
        return jsonWriter.writeEndObject();
    }

    public static CustomDomainConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (CustomDomainConfiguration)jsonReader.readObject(reader -> {
            CustomDomainConfiguration deserializedCustomDomainConfiguration = new CustomDomainConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customDomainVerificationId".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.customDomainVerificationId = reader.getString();
                    continue;
                }
                if ("dnsSuffix".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.dnsSuffix = reader.getString();
                    continue;
                }
                if ("certificateKeyVaultProperties".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.certificateKeyVaultProperties = CertificateKeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("certificateValue".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.certificateValue = reader.getBinary();
                    continue;
                }
                if ("certificatePassword".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.certificatePassword = reader.getString();
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.expirationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.thumbprint = reader.getString();
                    continue;
                }
                if ("subjectName".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.subjectName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomDomainConfiguration;
        });
    }
}

