/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContainerRegistryWithCustomImage
implements JsonSerializable<ContainerRegistryWithCustomImage> {
    private String server;
    private String image;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryWithCustomImage.class);

    public String server() {
        return this.server;
    }

    public ContainerRegistryWithCustomImage withServer(String server) {
        this.server = server;
        return this;
    }

    public String image() {
        return this.image;
    }

    public ContainerRegistryWithCustomImage withImage(String image) {
        this.image = image;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model ContainerRegistryWithCustomImage"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("image", this.image);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryWithCustomImage fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryWithCustomImage)jsonReader.readObject(reader -> {
            ContainerRegistryWithCustomImage deserializedContainerRegistryWithCustomImage = new ContainerRegistryWithCustomImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedContainerRegistryWithCustomImage.server = reader.getString();
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedContainerRegistryWithCustomImage.image = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryWithCustomImage;
        });
    }
}

