/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContainerRegistry
implements JsonSerializable<ContainerRegistry> {
    private String containerRegistryServer;
    private String identityResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistry.class);

    public String containerRegistryServer() {
        return this.containerRegistryServer;
    }

    public ContainerRegistry withContainerRegistryServer(String containerRegistryServer) {
        this.containerRegistryServer = containerRegistryServer;
        return this;
    }

    public String identityResourceId() {
        return this.identityResourceId;
    }

    public ContainerRegistry withIdentityResourceId(String identityResourceId) {
        this.identityResourceId = identityResourceId;
        return this;
    }

    public void validate() {
        if (this.containerRegistryServer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containerRegistryServer in model ContainerRegistry"));
        }
        if (this.identityResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property identityResourceId in model ContainerRegistry"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerRegistryServer", this.containerRegistryServer);
        jsonWriter.writeStringField("identityResourceId", this.identityResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistry fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistry)jsonReader.readObject(reader -> {
            ContainerRegistry deserializedContainerRegistry = new ContainerRegistry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerRegistryServer".equals(fieldName)) {
                    deserializedContainerRegistry.containerRegistryServer = reader.getString();
                    continue;
                }
                if ("identityResourceId".equals(fieldName)) {
                    deserializedContainerRegistry.identityResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistry;
        });
    }
}

