/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProbeHttpGet;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProbeTcpSocket;
import com.azure.resourcemanager.appcontainers.models.Type;
import java.io.IOException;

public final class ContainerAppProbe
implements JsonSerializable<ContainerAppProbe> {
    private Integer failureThreshold;
    private ContainerAppProbeHttpGet httpGet;
    private Integer initialDelaySeconds;
    private Integer periodSeconds;
    private Integer successThreshold;
    private ContainerAppProbeTcpSocket tcpSocket;
    private Long terminationGracePeriodSeconds;
    private Integer timeoutSeconds;
    private Type type;

    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    public ContainerAppProbe withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public ContainerAppProbeHttpGet httpGet() {
        return this.httpGet;
    }

    public ContainerAppProbe withHttpGet(ContainerAppProbeHttpGet httpGet) {
        this.httpGet = httpGet;
        return this;
    }

    public Integer initialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public ContainerAppProbe withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return this;
    }

    public Integer periodSeconds() {
        return this.periodSeconds;
    }

    public ContainerAppProbe withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    public Integer successThreshold() {
        return this.successThreshold;
    }

    public ContainerAppProbe withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    public ContainerAppProbeTcpSocket tcpSocket() {
        return this.tcpSocket;
    }

    public ContainerAppProbe withTcpSocket(ContainerAppProbeTcpSocket tcpSocket) {
        this.tcpSocket = tcpSocket;
        return this;
    }

    public Long terminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public ContainerAppProbe withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public ContainerAppProbe withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public Type type() {
        return this.type;
    }

    public ContainerAppProbe withType(Type type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.httpGet() != null) {
            this.httpGet().validate();
        }
        if (this.tcpSocket() != null) {
            this.tcpSocket().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("failureThreshold", (Number)this.failureThreshold);
        jsonWriter.writeJsonField("httpGet", (JsonSerializable)this.httpGet);
        jsonWriter.writeNumberField("initialDelaySeconds", (Number)this.initialDelaySeconds);
        jsonWriter.writeNumberField("periodSeconds", (Number)this.periodSeconds);
        jsonWriter.writeNumberField("successThreshold", (Number)this.successThreshold);
        jsonWriter.writeJsonField("tcpSocket", (JsonSerializable)this.tcpSocket);
        jsonWriter.writeNumberField("terminationGracePeriodSeconds", (Number)this.terminationGracePeriodSeconds);
        jsonWriter.writeNumberField("timeoutSeconds", (Number)this.timeoutSeconds);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppProbe fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerAppProbe)jsonReader.readObject(reader -> {
            ContainerAppProbe deserializedContainerAppProbe = new ContainerAppProbe();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("failureThreshold".equals(fieldName)) {
                    deserializedContainerAppProbe.failureThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpGet".equals(fieldName)) {
                    deserializedContainerAppProbe.httpGet = ContainerAppProbeHttpGet.fromJson(reader);
                    continue;
                }
                if ("initialDelaySeconds".equals(fieldName)) {
                    deserializedContainerAppProbe.initialDelaySeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("periodSeconds".equals(fieldName)) {
                    deserializedContainerAppProbe.periodSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("successThreshold".equals(fieldName)) {
                    deserializedContainerAppProbe.successThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("tcpSocket".equals(fieldName)) {
                    deserializedContainerAppProbe.tcpSocket = ContainerAppProbeTcpSocket.fromJson(reader);
                    continue;
                }
                if ("terminationGracePeriodSeconds".equals(fieldName)) {
                    deserializedContainerAppProbe.terminationGracePeriodSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("timeoutSeconds".equals(fieldName)) {
                    deserializedContainerAppProbe.timeoutSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerAppProbe.type = Type.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppProbe;
        });
    }
}

