/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppInner;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppAuthToken;
import com.azure.resourcemanager.appcontainers.models.ContainerAppPropertiesPatchingConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerAppRunningStatus;
import com.azure.resourcemanager.appcontainers.models.CustomHostnameAnalysisResult;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.azure.resourcemanager.appcontainers.models.Kind;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.SecretsCollection;
import com.azure.resourcemanager.appcontainers.models.Template;
import java.util.List;
import java.util.Map;

public interface ContainerApp {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public ManagedServiceIdentity identity();

    public String managedBy();

    public Kind kind();

    public SystemData systemData();

    public ContainerAppProvisioningState provisioningState();

    public ContainerAppRunningStatus runningStatus();

    public String deploymentErrors();

    public String managedEnvironmentId();

    public String environmentId();

    public String workloadProfileName();

    public ContainerAppPropertiesPatchingConfiguration patchingConfiguration();

    public String latestRevisionName();

    public String latestReadyRevisionName();

    public String latestRevisionFqdn();

    public String customDomainVerificationId();

    public Configuration configuration();

    public Template template();

    public List<String> outboundIpAddresses();

    public String eventStreamEndpoint();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ContainerAppInner innerModel();

    public Update update();

    public ContainerApp refresh();

    public ContainerApp refresh(Context var1);

    public Response<CustomHostnameAnalysisResult> listCustomHostnameAnalysisWithResponse(String var1, Context var2);

    public CustomHostnameAnalysisResult listCustomHostnameAnalysis();

    public Response<SecretsCollection> listSecretsWithResponse(Context var1);

    public SecretsCollection listSecrets();

    public Response<ContainerAppAuthToken> getAuthTokenWithResponse(Context var1);

    public ContainerAppAuthToken getAuthToken();

    public ContainerApp start();

    public ContainerApp start(Context var1);

    public ContainerApp stop();

    public ContainerApp stop(Context var1);

    public static interface UpdateStages {

        public static interface WithTemplate {
            public Update withTemplate(Template var1);
        }

        public static interface WithConfiguration {
            public Update withConfiguration(Configuration var1);
        }

        public static interface WithPatchingConfiguration {
            public Update withPatchingConfiguration(ContainerAppPropertiesPatchingConfiguration var1);
        }

        public static interface WithWorkloadProfileName {
            public Update withWorkloadProfileName(String var1);
        }

        public static interface WithManagedBy {
            public Update withManagedBy(String var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithExtendedLocation {
            public Update withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithExtendedLocation,
    UpdateStages.WithIdentity,
    UpdateStages.WithManagedBy,
    UpdateStages.WithWorkloadProfileName,
    UpdateStages.WithPatchingConfiguration,
    UpdateStages.WithConfiguration,
    UpdateStages.WithTemplate {
        public ContainerApp apply();

        public ContainerApp apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithTemplate {
            public WithCreate withTemplate(Template var1);
        }

        public static interface WithConfiguration {
            public WithCreate withConfiguration(Configuration var1);
        }

        public static interface WithPatchingConfiguration {
            public WithCreate withPatchingConfiguration(ContainerAppPropertiesPatchingConfiguration var1);
        }

        public static interface WithWorkloadProfileName {
            public WithCreate withWorkloadProfileName(String var1);
        }

        public static interface WithEnvironmentId {
            public WithCreate withEnvironmentId(String var1);
        }

        public static interface WithManagedEnvironmentId {
            public WithCreate withManagedEnvironmentId(String var1);
        }

        public static interface WithKind {
            public WithCreate withKind(Kind var1);
        }

        public static interface WithManagedBy {
            public WithCreate withManagedBy(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithExtendedLocation {
            public WithCreate withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithExtendedLocation,
        WithIdentity,
        WithManagedBy,
        WithKind,
        WithManagedEnvironmentId,
        WithEnvironmentId,
        WithWorkloadProfileName,
        WithPatchingConfiguration,
        WithConfiguration,
        WithTemplate {
            public ContainerApp create();

            public ContainerApp create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

