/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AzureFileProperties;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStorageProvisioningState;
import com.azure.resourcemanager.appcontainers.models.SmbStorage;
import java.io.IOException;

public final class ConnectedEnvironmentStorageProperties
implements JsonSerializable<ConnectedEnvironmentStorageProperties> {
    private ConnectedEnvironmentStorageProvisioningState provisioningState;
    private String deploymentErrors;
    private AzureFileProperties azureFile;
    private SmbStorage smb;

    public ConnectedEnvironmentStorageProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    public AzureFileProperties azureFile() {
        return this.azureFile;
    }

    public ConnectedEnvironmentStorageProperties withAzureFile(AzureFileProperties azureFile) {
        this.azureFile = azureFile;
        return this;
    }

    public SmbStorage smb() {
        return this.smb;
    }

    public ConnectedEnvironmentStorageProperties withSmb(SmbStorage smb) {
        this.smb = smb;
        return this;
    }

    public void validate() {
        if (this.azureFile() != null) {
            this.azureFile().validate();
        }
        if (this.smb() != null) {
            this.smb().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureFile", (JsonSerializable)this.azureFile);
        jsonWriter.writeJsonField("smb", (JsonSerializable)this.smb);
        return jsonWriter.writeEndObject();
    }

    public static ConnectedEnvironmentStorageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedEnvironmentStorageProperties)jsonReader.readObject(reader -> {
            ConnectedEnvironmentStorageProperties deserializedConnectedEnvironmentStorageProperties = new ConnectedEnvironmentStorageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageProperties.provisioningState = ConnectedEnvironmentStorageProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentErrors".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageProperties.deploymentErrors = reader.getString();
                    continue;
                }
                if ("azureFile".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageProperties.azureFile = AzureFileProperties.fromJson(reader);
                    continue;
                }
                if ("smb".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageProperties.smb = SmbStorage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectedEnvironmentStorageProperties;
        });
    }
}

