/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceUpdateProperties;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class BuilderResourceUpdate
implements JsonSerializable<BuilderResourceUpdate> {
    private ManagedServiceIdentity identity;
    private Map<String, String> tags;
    private BuilderResourceUpdateProperties innerProperties;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public BuilderResourceUpdate withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BuilderResourceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private BuilderResourceUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public BuilderResourceUpdate withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuilderResourceUpdateProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BuilderResourceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (BuilderResourceUpdate)jsonReader.readObject(reader -> {
            BuilderResourceUpdate deserializedBuilderResourceUpdate = new BuilderResourceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedBuilderResourceUpdate.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedBuilderResourceUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBuilderResourceUpdate.innerProperties = BuilderResourceUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuilderResourceUpdate;
        });
    }
}

