/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceInner;
import java.io.IOException;
import java.util.List;

public final class BuilderCollection
implements JsonSerializable<BuilderCollection> {
    private List<BuilderResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(BuilderCollection.class);

    public List<BuilderResourceInner> value() {
        return this.value;
    }

    public BuilderCollection withValue(List<BuilderResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public BuilderCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model BuilderCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static BuilderCollection fromJson(JsonReader jsonReader) throws IOException {
        return (BuilderCollection)jsonReader.readObject(reader -> {
            BuilderCollection deserializedBuilderCollection = new BuilderCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBuilderCollection.value = value = reader.readArray(reader1 -> BuilderResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedBuilderCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuilderCollection;
        });
    }
}

