/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVariable;
import com.azure.resourcemanager.appcontainers.models.PreBuildStep;
import java.io.IOException;
import java.util.List;

public final class BuildConfiguration
implements JsonSerializable<BuildConfiguration> {
    private String baseOs;
    private String platform;
    private String platformVersion;
    private List<EnvironmentVariable> environmentVariables;
    private List<PreBuildStep> preBuildSteps;

    public String baseOs() {
        return this.baseOs;
    }

    public BuildConfiguration withBaseOs(String baseOs) {
        this.baseOs = baseOs;
        return this;
    }

    public String platform() {
        return this.platform;
    }

    public BuildConfiguration withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public BuildConfiguration withPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public BuildConfiguration withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public List<PreBuildStep> preBuildSteps() {
        return this.preBuildSteps;
    }

    public BuildConfiguration withPreBuildSteps(List<PreBuildStep> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
        return this;
    }

    public void validate() {
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.preBuildSteps() != null) {
            this.preBuildSteps().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("baseOs", this.baseOs);
        jsonWriter.writeStringField("platform", this.platform);
        jsonWriter.writeStringField("platformVersion", this.platformVersion);
        jsonWriter.writeArrayField("environmentVariables", this.environmentVariables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("preBuildSteps", this.preBuildSteps, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BuildConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BuildConfiguration)jsonReader.readObject(reader -> {
            BuildConfiguration deserializedBuildConfiguration = new BuildConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseOs".equals(fieldName)) {
                    deserializedBuildConfiguration.baseOs = reader.getString();
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedBuildConfiguration.platform = reader.getString();
                    continue;
                }
                if ("platformVersion".equals(fieldName)) {
                    deserializedBuildConfiguration.platformVersion = reader.getString();
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    List environmentVariables;
                    deserializedBuildConfiguration.environmentVariables = environmentVariables = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    continue;
                }
                if ("preBuildSteps".equals(fieldName)) {
                    List preBuildSteps;
                    deserializedBuildConfiguration.preBuildSteps = preBuildSteps = reader.readArray(reader1 -> PreBuildStep.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildConfiguration;
        });
    }
}

