/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;
import java.io.IOException;
import java.util.List;

public final class AppResiliencyCollection
implements JsonSerializable<AppResiliencyCollection> {
    private List<AppResiliencyInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AppResiliencyCollection.class);

    public List<AppResiliencyInner> value() {
        return this.value;
    }

    public AppResiliencyCollection withValue(List<AppResiliencyInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AppResiliencyCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AppResiliencyCollection fromJson(JsonReader jsonReader) throws IOException {
        return (AppResiliencyCollection)jsonReader.readObject(reader -> {
            AppResiliencyCollection deserializedAppResiliencyCollection = new AppResiliencyCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAppResiliencyCollection.value = value = reader.readArray(reader1 -> AppResiliencyInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAppResiliencyCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppResiliencyCollection;
        });
    }
}

