/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.SourceControlInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.GithubActionConfiguration;
import com.azure.resourcemanager.appcontainers.models.SourceControl;
import com.azure.resourcemanager.appcontainers.models.SourceControlOperationState;

public final class SourceControlImpl
implements SourceControl,
SourceControl.Definition,
SourceControl.Update {
    private SourceControlInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String containerAppName;
    private String sourceControlName;
    private String createXMsGithubAuxiliary;
    private String updateXMsGithubAuxiliary;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SourceControlOperationState operationState() {
        return this.innerModel().operationState();
    }

    @Override
    public String repoUrl() {
        return this.innerModel().repoUrl();
    }

    @Override
    public String branch() {
        return this.innerModel().branch();
    }

    @Override
    public GithubActionConfiguration githubActionConfiguration() {
        return this.innerModel().githubActionConfiguration();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SourceControlInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public SourceControlImpl withExistingContainerApp(String resourceGroupName, String containerAppName) {
        this.resourceGroupName = resourceGroupName;
        this.containerAppName = containerAppName;
        return this;
    }

    @Override
    public SourceControl create() {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSourceControls().createOrUpdate(this.resourceGroupName, this.containerAppName, this.sourceControlName, this.innerModel(), this.createXMsGithubAuxiliary, Context.NONE);
        return this;
    }

    @Override
    public SourceControl create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSourceControls().createOrUpdate(this.resourceGroupName, this.containerAppName, this.sourceControlName, this.innerModel(), this.createXMsGithubAuxiliary, context);
        return this;
    }

    SourceControlImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new SourceControlInner();
        this.serviceManager = serviceManager;
        this.sourceControlName = name;
        this.createXMsGithubAuxiliary = null;
    }

    @Override
    public SourceControlImpl update() {
        this.updateXMsGithubAuxiliary = null;
        return this;
    }

    @Override
    public SourceControl apply() {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSourceControls().createOrUpdate(this.resourceGroupName, this.containerAppName, this.sourceControlName, this.innerModel(), this.updateXMsGithubAuxiliary, Context.NONE);
        return this;
    }

    @Override
    public SourceControl apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSourceControls().createOrUpdate(this.resourceGroupName, this.containerAppName, this.sourceControlName, this.innerModel(), this.updateXMsGithubAuxiliary, context);
        return this;
    }

    SourceControlImpl(SourceControlInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.containerAppName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "containerApps");
        this.sourceControlName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sourcecontrols");
    }

    @Override
    public SourceControl refresh() {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getContainerAppsSourceControls().getWithResponse(this.resourceGroupName, this.containerAppName, this.sourceControlName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SourceControl refresh(Context context) {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getContainerAppsSourceControls().getWithResponse(this.resourceGroupName, this.containerAppName, this.sourceControlName, context).getValue());
        return this;
    }

    @Override
    public SourceControlImpl withRepoUrl(String repoUrl) {
        this.innerModel().withRepoUrl(repoUrl);
        return this;
    }

    @Override
    public SourceControlImpl withBranch(String branch) {
        this.innerModel().withBranch(branch);
        return this;
    }

    @Override
    public SourceControlImpl withGithubActionConfiguration(GithubActionConfiguration githubActionConfiguration) {
        this.innerModel().withGithubActionConfiguration(githubActionConfiguration);
        return this;
    }

    @Override
    public SourceControlImpl withXMsGithubAuxiliary(String xMsGithubAuxiliary) {
        if (this.isInCreateMode()) {
            this.createXMsGithubAuxiliary = xMsGithubAuxiliary;
            return this;
        }
        this.updateXMsGithubAuxiliary = xMsGithubAuxiliary;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

