/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.NamespacesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.CheckNameAvailabilityResponseInner;
import com.azure.resourcemanager.appcontainers.implementation.CheckNameAvailabilityResponseImpl;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.appcontainers.models.Namespaces;

public final class NamespacesImpl
implements Namespaces {
    private static final ClientLogger LOGGER = new ClientLogger(NamespacesImpl.class);
    private final NamespacesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public NamespacesImpl(NamespacesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(String resourceGroupName, String environmentName, CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context) {
        Response<CheckNameAvailabilityResponseInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, environmentName, checkNameAvailabilityRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResponseImpl((CheckNameAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(String resourceGroupName, String environmentName, CheckNameAvailabilityRequest checkNameAvailabilityRequest) {
        CheckNameAvailabilityResponseInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, environmentName, checkNameAvailabilityRequest);
        if (inner != null) {
            return new CheckNameAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    private NamespacesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

