/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStorage;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStorageProperties;

public final class ManagedEnvironmentStorageImpl
implements ManagedEnvironmentStorage,
ManagedEnvironmentStorage.Definition,
ManagedEnvironmentStorage.Update {
    private ManagedEnvironmentStorageInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String storageName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ManagedEnvironmentStorageProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedEnvironmentStorageInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedEnvironmentStorageImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public ManagedEnvironmentStorage create() {
        this.innerObject = (ManagedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getManagedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.storageName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedEnvironmentStorage create(Context context) {
        this.innerObject = (ManagedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getManagedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.storageName, this.innerModel(), context).getValue());
        return this;
    }

    ManagedEnvironmentStorageImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new ManagedEnvironmentStorageInner();
        this.serviceManager = serviceManager;
        this.storageName = name;
    }

    @Override
    public ManagedEnvironmentStorageImpl update() {
        return this;
    }

    @Override
    public ManagedEnvironmentStorage apply() {
        this.innerObject = (ManagedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getManagedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.storageName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedEnvironmentStorage apply(Context context) {
        this.innerObject = (ManagedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getManagedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.storageName, this.innerModel(), context).getValue());
        return this;
    }

    ManagedEnvironmentStorageImpl(ManagedEnvironmentStorageInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.storageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storages");
    }

    @Override
    public ManagedEnvironmentStorage refresh() {
        this.innerObject = (ManagedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getManagedEnvironmentsStorages().getWithResponse(this.resourceGroupName, this.environmentName, this.storageName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedEnvironmentStorage refresh(Context context) {
        this.innerObject = (ManagedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getManagedEnvironmentsStorages().getWithResponse(this.resourceGroupName, this.environmentName, this.storageName, context).getValue());
        return this;
    }

    @Override
    public ManagedEnvironmentStorageImpl withProperties(ManagedEnvironmentStorageProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

