/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.appcontainers.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.AppInsightsConfiguration;
import com.azure.resourcemanager.appcontainers.models.AppLogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.DaprConfiguration;
import com.azure.resourcemanager.appcontainers.models.DiskEncryptionConfiguration;
import com.azure.resourcemanager.appcontainers.models.EnvironmentAuthToken;
import com.azure.resourcemanager.appcontainers.models.EnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.IngressConfiguration;
import com.azure.resourcemanager.appcontainers.models.KedaConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.OpenTelemetryConfiguration;
import com.azure.resourcemanager.appcontainers.models.PrivateEndpointConnection;
import com.azure.resourcemanager.appcontainers.models.PublicNetworkAccess;
import com.azure.resourcemanager.appcontainers.models.VnetConfiguration;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ManagedEnvironmentImpl
implements ManagedEnvironment,
ManagedEnvironment.Definition,
ManagedEnvironment.Update {
    private ManagedEnvironmentInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String kind() {
        return this.innerModel().kind();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public EnvironmentProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String daprAIInstrumentationKey() {
        return this.innerModel().daprAIInstrumentationKey();
    }

    @Override
    public String daprAIConnectionString() {
        return this.innerModel().daprAIConnectionString();
    }

    @Override
    public VnetConfiguration vnetConfiguration() {
        return this.innerModel().vnetConfiguration();
    }

    @Override
    public String deploymentErrors() {
        return this.innerModel().deploymentErrors();
    }

    @Override
    public String defaultDomain() {
        return this.innerModel().defaultDomain();
    }

    @Override
    public String privateLinkDefaultDomain() {
        return this.innerModel().privateLinkDefaultDomain();
    }

    @Override
    public String staticIp() {
        return this.innerModel().staticIp();
    }

    @Override
    public AppLogsConfiguration appLogsConfiguration() {
        return this.innerModel().appLogsConfiguration();
    }

    @Override
    public AppInsightsConfiguration appInsightsConfiguration() {
        return this.innerModel().appInsightsConfiguration();
    }

    @Override
    public OpenTelemetryConfiguration openTelemetryConfiguration() {
        return this.innerModel().openTelemetryConfiguration();
    }

    @Override
    public Boolean zoneRedundant() {
        return this.innerModel().zoneRedundant();
    }

    @Override
    public List<String> availabilityZones() {
        List<String> inner = this.innerModel().availabilityZones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public CustomDomainConfiguration customDomainConfiguration() {
        return this.innerModel().customDomainConfiguration();
    }

    @Override
    public String eventStreamEndpoint() {
        return this.innerModel().eventStreamEndpoint();
    }

    @Override
    public List<WorkloadProfile> workloadProfiles() {
        List<WorkloadProfile> inner = this.innerModel().workloadProfiles();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public KedaConfiguration kedaConfiguration() {
        return this.innerModel().kedaConfiguration();
    }

    @Override
    public DaprConfiguration daprConfiguration() {
        return this.innerModel().daprConfiguration();
    }

    @Override
    public String infrastructureResourceGroup() {
        return this.innerModel().infrastructureResourceGroup();
    }

    @Override
    public ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication() {
        return this.innerModel().peerAuthentication();
    }

    @Override
    public ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration() {
        return this.innerModel().peerTrafficConfiguration();
    }

    @Override
    public IngressConfiguration ingressConfiguration() {
        return this.innerModel().ingressConfiguration();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public DiskEncryptionConfiguration diskEncryptionConfiguration() {
        return this.innerModel().diskEncryptionConfiguration();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedEnvironmentInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedEnvironmentImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ManagedEnvironment create() {
        this.innerObject = this.serviceManager.serviceClient().getManagedEnvironments().createOrUpdate(this.resourceGroupName, this.environmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedEnvironment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedEnvironments().createOrUpdate(this.resourceGroupName, this.environmentName, this.innerModel(), context);
        return this;
    }

    ManagedEnvironmentImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new ManagedEnvironmentInner();
        this.serviceManager = serviceManager;
        this.environmentName = name;
    }

    @Override
    public ManagedEnvironmentImpl update() {
        return this;
    }

    @Override
    public ManagedEnvironment apply() {
        this.innerObject = this.serviceManager.serviceClient().getManagedEnvironments().update(this.resourceGroupName, this.environmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedEnvironment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedEnvironments().update(this.resourceGroupName, this.environmentName, this.innerModel(), context);
        return this;
    }

    ManagedEnvironmentImpl(ManagedEnvironmentInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
    }

    @Override
    public ManagedEnvironment refresh() {
        this.innerObject = (ManagedEnvironmentInner)((Object)this.serviceManager.serviceClient().getManagedEnvironments().getByResourceGroupWithResponse(this.resourceGroupName, this.environmentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedEnvironment refresh(Context context) {
        this.innerObject = (ManagedEnvironmentInner)((Object)this.serviceManager.serviceClient().getManagedEnvironments().getByResourceGroupWithResponse(this.resourceGroupName, this.environmentName, context).getValue());
        return this;
    }

    @Override
    public Response<EnvironmentAuthToken> getAuthTokenWithResponse(Context context) {
        return this.serviceManager.managedEnvironments().getAuthTokenWithResponse(this.resourceGroupName, this.environmentName, context);
    }

    @Override
    public EnvironmentAuthToken getAuthToken() {
        return this.serviceManager.managedEnvironments().getAuthToken(this.resourceGroupName, this.environmentName);
    }

    @Override
    public ManagedEnvironmentImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withKind(String kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withIdentity(ManagedServiceIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withDaprAIInstrumentationKey(String daprAIInstrumentationKey) {
        this.innerModel().withDaprAIInstrumentationKey(daprAIInstrumentationKey);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withDaprAIConnectionString(String daprAIConnectionString) {
        this.innerModel().withDaprAIConnectionString(daprAIConnectionString);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withVnetConfiguration(VnetConfiguration vnetConfiguration) {
        this.innerModel().withVnetConfiguration(vnetConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        this.innerModel().withAppLogsConfiguration(appLogsConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withAppInsightsConfiguration(AppInsightsConfiguration appInsightsConfiguration) {
        this.innerModel().withAppInsightsConfiguration(appInsightsConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withOpenTelemetryConfiguration(OpenTelemetryConfiguration openTelemetryConfiguration) {
        this.innerModel().withOpenTelemetryConfiguration(openTelemetryConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withZoneRedundant(Boolean zoneRedundant) {
        this.innerModel().withZoneRedundant(zoneRedundant);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withAvailabilityZones(List<String> availabilityZones) {
        this.innerModel().withAvailabilityZones(availabilityZones);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        this.innerModel().withCustomDomainConfiguration(customDomainConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withWorkloadProfiles(List<WorkloadProfile> workloadProfiles) {
        this.innerModel().withWorkloadProfiles(workloadProfiles);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withKedaConfiguration(KedaConfiguration kedaConfiguration) {
        this.innerModel().withKedaConfiguration(kedaConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withDaprConfiguration(DaprConfiguration daprConfiguration) {
        this.innerModel().withDaprConfiguration(daprConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withInfrastructureResourceGroup(String infrastructureResourceGroup) {
        this.innerModel().withInfrastructureResourceGroup(infrastructureResourceGroup);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withPeerAuthentication(ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication) {
        this.innerModel().withPeerAuthentication(peerAuthentication);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withPeerTrafficConfiguration(ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration) {
        this.innerModel().withPeerTrafficConfiguration(peerTrafficConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withIngressConfiguration(IngressConfiguration ingressConfiguration) {
        this.innerModel().withIngressConfiguration(ingressConfiguration);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ManagedEnvironmentImpl withDiskEncryptionConfiguration(DiskEncryptionConfiguration diskEncryptionConfiguration) {
        this.innerModel().withDiskEncryptionConfiguration(diskEncryptionConfiguration);
        return this;
    }
}

