/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.MaintenanceConfigurationsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.MaintenanceConfigurationResourceInner;
import com.azure.resourcemanager.appcontainers.implementation.MaintenanceConfigurationResourceImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.MaintenanceConfigurationResource;
import com.azure.resourcemanager.appcontainers.models.MaintenanceConfigurations;

public final class MaintenanceConfigurationsImpl
implements MaintenanceConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(MaintenanceConfigurationsImpl.class);
    private final MaintenanceConfigurationsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public MaintenanceConfigurationsImpl(MaintenanceConfigurationsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<MaintenanceConfigurationResource> list(String resourceGroupName, String environmentName) {
        PagedIterable<MaintenanceConfigurationResourceInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MaintenanceConfigurationResourceImpl((MaintenanceConfigurationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MaintenanceConfigurationResource> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<MaintenanceConfigurationResourceInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MaintenanceConfigurationResourceImpl((MaintenanceConfigurationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String configName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, configName, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String configName) {
        this.serviceClient().delete(resourceGroupName, environmentName, configName);
    }

    @Override
    public Response<MaintenanceConfigurationResource> getWithResponse(String resourceGroupName, String environmentName, String configName, Context context) {
        Response<MaintenanceConfigurationResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, configName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MaintenanceConfigurationResourceImpl((MaintenanceConfigurationResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public MaintenanceConfigurationResource get(String resourceGroupName, String environmentName, String configName) {
        MaintenanceConfigurationResourceInner inner = this.serviceClient().get(resourceGroupName, environmentName, configName);
        if (inner != null) {
            return new MaintenanceConfigurationResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public MaintenanceConfigurationResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String configName = ResourceManagerUtils.getValueFromIdByName(id, "maintenanceConfigurations");
        if (configName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maintenanceConfigurations'.", id)));
        }
        return (MaintenanceConfigurationResource)this.getWithResponse(resourceGroupName, environmentName, configName, Context.NONE).getValue();
    }

    @Override
    public Response<MaintenanceConfigurationResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String configName = ResourceManagerUtils.getValueFromIdByName(id, "maintenanceConfigurations");
        if (configName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maintenanceConfigurations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, configName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String configName = ResourceManagerUtils.getValueFromIdByName(id, "maintenanceConfigurations");
        if (configName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maintenanceConfigurations'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, configName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String configName = ResourceManagerUtils.getValueFromIdByName(id, "maintenanceConfigurations");
        if (configName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maintenanceConfigurations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, configName, context);
    }

    private MaintenanceConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public MaintenanceConfigurationResourceImpl define(String name) {
        return new MaintenanceConfigurationResourceImpl(name, this.manager());
    }
}

