/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.JavaComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;
import com.azure.resourcemanager.appcontainers.implementation.JavaComponentImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.JavaComponent;
import com.azure.resourcemanager.appcontainers.models.JavaComponents;

public final class JavaComponentsImpl
implements JavaComponents {
    private static final ClientLogger LOGGER = new ClientLogger(JavaComponentsImpl.class);
    private final JavaComponentsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public JavaComponentsImpl(JavaComponentsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<JavaComponent> list(String resourceGroupName, String environmentName) {
        PagedIterable<JavaComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JavaComponentImpl((JavaComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JavaComponent> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<JavaComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JavaComponentImpl((JavaComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<JavaComponent> getWithResponse(String resourceGroupName, String environmentName, String name, Context context) {
        Response<JavaComponentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JavaComponentImpl((JavaComponentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public JavaComponent get(String resourceGroupName, String environmentName, String name) {
        JavaComponentInner inner = this.serviceClient().get(resourceGroupName, environmentName, name);
        if (inner != null) {
            return new JavaComponentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String name) {
        this.serviceClient().delete(resourceGroupName, environmentName, name);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String name, Context context) {
        this.serviceClient().delete(resourceGroupName, environmentName, name, context);
    }

    @Override
    public JavaComponent getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        return (JavaComponent)this.getWithResponse(resourceGroupName, environmentName, name, Context.NONE).getValue();
    }

    @Override
    public Response<JavaComponent> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, name, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        this.delete(resourceGroupName, environmentName, name, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        this.delete(resourceGroupName, environmentName, name, context);
    }

    private JavaComponentsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public JavaComponentImpl define(String name) {
        return new JavaComponentImpl(name, this.manager());
    }
}

