/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.HttpRouteConfigsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.HttpRouteConfigInner;
import com.azure.resourcemanager.appcontainers.implementation.HttpRouteConfigImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.HttpRouteConfig;
import com.azure.resourcemanager.appcontainers.models.HttpRouteConfigs;

public final class HttpRouteConfigsImpl
implements HttpRouteConfigs {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRouteConfigsImpl.class);
    private final HttpRouteConfigsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public HttpRouteConfigsImpl(HttpRouteConfigsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<HttpRouteConfig> getWithResponse(String resourceGroupName, String environmentName, String httpRouteName, Context context) {
        Response<HttpRouteConfigInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, httpRouteName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new HttpRouteConfigImpl((HttpRouteConfigInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public HttpRouteConfig get(String resourceGroupName, String environmentName, String httpRouteName) {
        HttpRouteConfigInner inner = this.serviceClient().get(resourceGroupName, environmentName, httpRouteName);
        if (inner != null) {
            return new HttpRouteConfigImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String httpRouteName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, httpRouteName, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String httpRouteName) {
        this.serviceClient().delete(resourceGroupName, environmentName, httpRouteName);
    }

    @Override
    public PagedIterable<HttpRouteConfig> list(String resourceGroupName, String environmentName) {
        PagedIterable<HttpRouteConfigInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HttpRouteConfigImpl((HttpRouteConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<HttpRouteConfig> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<HttpRouteConfigInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HttpRouteConfigImpl((HttpRouteConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public HttpRouteConfig getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String httpRouteName = ResourceManagerUtils.getValueFromIdByName(id, "httpRouteConfigs");
        if (httpRouteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'httpRouteConfigs'.", id)));
        }
        return (HttpRouteConfig)this.getWithResponse(resourceGroupName, environmentName, httpRouteName, Context.NONE).getValue();
    }

    @Override
    public Response<HttpRouteConfig> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String httpRouteName = ResourceManagerUtils.getValueFromIdByName(id, "httpRouteConfigs");
        if (httpRouteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'httpRouteConfigs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, httpRouteName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String httpRouteName = ResourceManagerUtils.getValueFromIdByName(id, "httpRouteConfigs");
        if (httpRouteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'httpRouteConfigs'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, httpRouteName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String httpRouteName = ResourceManagerUtils.getValueFromIdByName(id, "httpRouteConfigs");
        if (httpRouteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'httpRouteConfigs'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, httpRouteName, context);
    }

    private HttpRouteConfigsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public HttpRouteConfigImpl define(String name) {
        return new HttpRouteConfigImpl(name, this.manager());
    }
}

