/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.HttpRouteConfigsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.HttpRouteConfigInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appcontainers.models.HttpRouteConfigCollection;
import reactor.core.publisher.Mono;

public final class HttpRouteConfigsClientImpl
implements HttpRouteConfigsClient {
    private final HttpRouteConfigsService service;
    private final ContainerAppsApiClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(HttpRouteConfigsClientImpl.class);

    HttpRouteConfigsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (HttpRouteConfigsService)RestProxy.create(HttpRouteConfigsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HttpRouteConfigInner>> getWithResponseAsync(String resourceGroupName, String environmentName, String httpRouteName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<HttpRouteConfigInner> getAsync(String resourceGroupName, String environmentName, String httpRouteName) {
        return this.getWithResponseAsync(resourceGroupName, environmentName, httpRouteName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((HttpRouteConfigInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HttpRouteConfigInner> getWithResponse(String resourceGroupName, String environmentName, String httpRouteName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HttpRouteConfigInner get(String resourceGroupName, String environmentName, String httpRouteName) {
        return (HttpRouteConfigInner)((Object)this.getWithResponse(resourceGroupName, environmentName, httpRouteName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HttpRouteConfigInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String environmentName, String httpRouteName, HttpRouteConfigInner httpRouteConfigEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        if (httpRouteConfigEnvelope != null) {
            httpRouteConfigEnvelope.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), httpRouteConfigEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<HttpRouteConfigInner> createOrUpdateAsync(String resourceGroupName, String environmentName, String httpRouteName) {
        HttpRouteConfigInner httpRouteConfigEnvelope = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, environmentName, httpRouteName, httpRouteConfigEnvelope).flatMap(res -> Mono.justOrEmpty((Object)((Object)((HttpRouteConfigInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HttpRouteConfigInner> createOrUpdateWithResponse(String resourceGroupName, String environmentName, String httpRouteName, HttpRouteConfigInner httpRouteConfigEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        if (httpRouteConfigEnvelope != null) {
            httpRouteConfigEnvelope.validate();
        }
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), httpRouteConfigEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HttpRouteConfigInner createOrUpdate(String resourceGroupName, String environmentName, String httpRouteName) {
        HttpRouteConfigInner httpRouteConfigEnvelope = null;
        return (HttpRouteConfigInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, environmentName, httpRouteName, httpRouteConfigEnvelope, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HttpRouteConfigInner>> updateWithResponseAsync(String resourceGroupName, String environmentName, String httpRouteName, HttpRouteConfigInner httpRouteConfigEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        if (httpRouteConfigEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter httpRouteConfigEnvelope is required and cannot be null."));
        }
        httpRouteConfigEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), httpRouteConfigEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<HttpRouteConfigInner> updateAsync(String resourceGroupName, String environmentName, String httpRouteName, HttpRouteConfigInner httpRouteConfigEnvelope) {
        return this.updateWithResponseAsync(resourceGroupName, environmentName, httpRouteName, httpRouteConfigEnvelope).flatMap(res -> Mono.justOrEmpty((Object)((Object)((HttpRouteConfigInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HttpRouteConfigInner> updateWithResponse(String resourceGroupName, String environmentName, String httpRouteName, HttpRouteConfigInner httpRouteConfigEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        if (httpRouteConfigEnvelope == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter httpRouteConfigEnvelope is required and cannot be null."));
        }
        httpRouteConfigEnvelope.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), httpRouteConfigEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HttpRouteConfigInner update(String resourceGroupName, String environmentName, String httpRouteName, HttpRouteConfigInner httpRouteConfigEnvelope) {
        return (HttpRouteConfigInner)((Object)this.updateWithResponse(resourceGroupName, environmentName, httpRouteName, httpRouteConfigEnvelope, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String environmentName, String httpRouteName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String environmentName, String httpRouteName) {
        return this.deleteWithResponseAsync(resourceGroupName, environmentName, httpRouteName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String httpRouteName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (httpRouteName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter httpRouteName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, httpRouteName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String environmentName, String httpRouteName) {
        this.deleteWithResponse(resourceGroupName, environmentName, httpRouteName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HttpRouteConfigInner>> listSinglePageAsync(String resourceGroupName, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HttpRouteConfigCollection)res.getValue()).value(), ((HttpRouteConfigCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<HttpRouteConfigInner> listAsync(String resourceGroupName, String environmentName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, environmentName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HttpRouteConfigInner> listSinglePage(String resourceGroupName, String environmentName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HttpRouteConfigCollection> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HttpRouteConfigCollection)res.getValue()).value(), ((HttpRouteConfigCollection)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HttpRouteConfigInner> listSinglePage(String resourceGroupName, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HttpRouteConfigCollection> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HttpRouteConfigCollection)res.getValue()).value(), ((HttpRouteConfigCollection)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HttpRouteConfigInner> list(String resourceGroupName, String environmentName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, environmentName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HttpRouteConfigInner> list(String resourceGroupName, String environmentName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, environmentName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HttpRouteConfigInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HttpRouteConfigCollection)res.getValue()).value(), ((HttpRouteConfigCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HttpRouteConfigInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HttpRouteConfigCollection> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HttpRouteConfigCollection)res.getValue()).value(), ((HttpRouteConfigCollection)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HttpRouteConfigInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HttpRouteConfigCollection> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HttpRouteConfigCollection)res.getValue()).value(), ((HttpRouteConfigCollection)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClientHttpRouteConfigs")
    public static interface HttpRouteConfigsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<HttpRouteConfigInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<HttpRouteConfigInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<HttpRouteConfigInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") HttpRouteConfigInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<HttpRouteConfigInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") HttpRouteConfigInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<HttpRouteConfigInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") HttpRouteConfigInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<HttpRouteConfigInner> updateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") HttpRouteConfigInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs/{httpRouteName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="httpRouteName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<HttpRouteConfigCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/httpRouteConfigs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<HttpRouteConfigCollection> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<HttpRouteConfigCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<HttpRouteConfigCollection> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

