/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.HttpRouteConfigInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.HttpRouteConfig;
import com.azure.resourcemanager.appcontainers.models.HttpRouteConfigProperties;

public final class HttpRouteConfigImpl
implements HttpRouteConfig,
HttpRouteConfig.Definition,
HttpRouteConfig.Update {
    private HttpRouteConfigInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String httpRouteName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public HttpRouteConfigProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public HttpRouteConfigInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public HttpRouteConfigImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public HttpRouteConfig create() {
        this.innerObject = (HttpRouteConfigInner)((Object)this.serviceManager.serviceClient().getHttpRouteConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.httpRouteName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public HttpRouteConfig create(Context context) {
        this.innerObject = (HttpRouteConfigInner)((Object)this.serviceManager.serviceClient().getHttpRouteConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.httpRouteName, this.innerModel(), context).getValue());
        return this;
    }

    HttpRouteConfigImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new HttpRouteConfigInner();
        this.serviceManager = serviceManager;
        this.httpRouteName = name;
    }

    @Override
    public HttpRouteConfigImpl update() {
        return this;
    }

    @Override
    public HttpRouteConfig apply() {
        this.innerObject = (HttpRouteConfigInner)((Object)this.serviceManager.serviceClient().getHttpRouteConfigs().updateWithResponse(this.resourceGroupName, this.environmentName, this.httpRouteName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public HttpRouteConfig apply(Context context) {
        this.innerObject = (HttpRouteConfigInner)((Object)this.serviceManager.serviceClient().getHttpRouteConfigs().updateWithResponse(this.resourceGroupName, this.environmentName, this.httpRouteName, this.innerModel(), context).getValue());
        return this;
    }

    HttpRouteConfigImpl(HttpRouteConfigInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.httpRouteName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "httpRouteConfigs");
    }

    @Override
    public HttpRouteConfig refresh() {
        this.innerObject = (HttpRouteConfigInner)((Object)this.serviceManager.serviceClient().getHttpRouteConfigs().getWithResponse(this.resourceGroupName, this.environmentName, this.httpRouteName, Context.NONE).getValue());
        return this;
    }

    @Override
    public HttpRouteConfig refresh(Context context) {
        this.innerObject = (HttpRouteConfigInner)((Object)this.serviceManager.serviceClient().getHttpRouteConfigs().getWithResponse(this.resourceGroupName, this.environmentName, this.httpRouteName, context).getValue());
        return this;
    }

    @Override
    public HttpRouteConfigImpl withProperties(HttpRouteConfigProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

