/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.DotNetComponent;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentType;
import java.util.Collections;
import java.util.List;

public final class DotNetComponentImpl
implements DotNetComponent,
DotNetComponent.Definition,
DotNetComponent.Update {
    private DotNetComponentInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String name;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public DotNetComponentType componentType() {
        return this.innerModel().componentType();
    }

    @Override
    public DotNetComponentProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<DotNetComponentConfigurationProperty> configurations() {
        List<DotNetComponentConfigurationProperty> inner = this.innerModel().configurations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DotNetComponentServiceBind> serviceBinds() {
        List<DotNetComponentServiceBind> inner = this.innerModel().serviceBinds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DotNetComponentInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DotNetComponentImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public DotNetComponent create() {
        this.innerObject = this.serviceManager.serviceClient().getDotNetComponents().createOrUpdate(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DotNetComponent create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDotNetComponents().createOrUpdate(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), context);
        return this;
    }

    DotNetComponentImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new DotNetComponentInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public DotNetComponentImpl update() {
        return this;
    }

    @Override
    public DotNetComponent apply() {
        this.innerObject = this.serviceManager.serviceClient().getDotNetComponents().update(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DotNetComponent apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDotNetComponents().update(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), context);
        return this;
    }

    DotNetComponentImpl(DotNetComponentInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dotNetComponents");
    }

    @Override
    public DotNetComponent refresh() {
        this.innerObject = (DotNetComponentInner)((Object)this.serviceManager.serviceClient().getDotNetComponents().getWithResponse(this.resourceGroupName, this.environmentName, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public DotNetComponent refresh(Context context) {
        this.innerObject = (DotNetComponentInner)((Object)this.serviceManager.serviceClient().getDotNetComponents().getWithResponse(this.resourceGroupName, this.environmentName, this.name, context).getValue());
        return this;
    }

    @Override
    public DotNetComponentImpl withComponentType(DotNetComponentType componentType) {
        this.innerModel().withComponentType(componentType);
        return this;
    }

    @Override
    public DotNetComponentImpl withConfigurations(List<DotNetComponentConfigurationProperty> configurations) {
        this.innerModel().withConfigurations(configurations);
        return this;
    }

    @Override
    public DotNetComponentImpl withServiceBinds(List<DotNetComponentServiceBind> serviceBinds) {
        this.innerModel().withServiceBinds(serviceBinds);
        return this;
    }
}

