/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.DaprComponentImpl;
import com.azure.resourcemanager.appcontainers.implementation.DaprSecretsCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.DaprComponent;
import com.azure.resourcemanager.appcontainers.models.DaprComponents;
import com.azure.resourcemanager.appcontainers.models.DaprSecretsCollection;

public final class DaprComponentsImpl
implements DaprComponents {
    private static final ClientLogger LOGGER = new ClientLogger(DaprComponentsImpl.class);
    private final DaprComponentsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public DaprComponentsImpl(DaprComponentsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName) {
        PagedIterable<DaprComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DaprComponentImpl((DaprComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<DaprComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DaprComponentImpl((DaprComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DaprComponent> getWithResponse(String resourceGroupName, String environmentName, String componentName, Context context) {
        Response<DaprComponentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprComponentImpl((DaprComponentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DaprComponent get(String resourceGroupName, String environmentName, String componentName) {
        DaprComponentInner inner = this.serviceClient().get(resourceGroupName, environmentName, componentName);
        if (inner != null) {
            return new DaprComponentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String componentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, componentName, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String componentName) {
        this.serviceClient().delete(resourceGroupName, environmentName, componentName);
    }

    @Override
    public Response<DaprSecretsCollection> listSecretsWithResponse(String resourceGroupName, String environmentName, String componentName, Context context) {
        Response<DaprSecretsCollectionInner> inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, environmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprSecretsCollectionImpl((DaprSecretsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DaprSecretsCollection listSecrets(String resourceGroupName, String environmentName, String componentName) {
        DaprSecretsCollectionInner inner = this.serviceClient().listSecrets(resourceGroupName, environmentName, componentName);
        if (inner != null) {
            return new DaprSecretsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DaprComponent getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        return (DaprComponent)this.getWithResponse(resourceGroupName, environmentName, componentName, Context.NONE).getValue();
    }

    @Override
    public Response<DaprComponent> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, componentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, componentName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, componentName, context);
    }

    private DaprComponentsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DaprComponentImpl define(String name) {
        return new DaprComponentImpl(name, this.manager());
    }
}

