/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.DaprComponent;
import com.azure.resourcemanager.appcontainers.models.DaprComponentServiceBinding;
import com.azure.resourcemanager.appcontainers.models.DaprMetadata;
import com.azure.resourcemanager.appcontainers.models.DaprSecretsCollection;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.util.Collections;
import java.util.List;

public final class DaprComponentImpl
implements DaprComponent,
DaprComponent.Definition,
DaprComponent.Update {
    private DaprComponentInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String componentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String componentType() {
        return this.innerModel().componentType();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public Boolean ignoreErrors() {
        return this.innerModel().ignoreErrors();
    }

    @Override
    public String initTimeout() {
        return this.innerModel().initTimeout();
    }

    @Override
    public List<Secret> secrets() {
        List<Secret> inner = this.innerModel().secrets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String secretStoreComponent() {
        return this.innerModel().secretStoreComponent();
    }

    @Override
    public List<DaprMetadata> metadata() {
        List<DaprMetadata> inner = this.innerModel().metadata();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> scopes() {
        List<String> inner = this.innerModel().scopes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DaprComponentServiceBinding> serviceComponentBind() {
        List<DaprComponentServiceBinding> inner = this.innerModel().serviceComponentBind();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DaprComponentInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DaprComponentImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public DaprComponent create() {
        this.innerObject = (DaprComponentInner)((Object)this.serviceManager.serviceClient().getDaprComponents().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprComponent create(Context context) {
        this.innerObject = (DaprComponentInner)((Object)this.serviceManager.serviceClient().getDaprComponents().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.innerModel(), context).getValue());
        return this;
    }

    DaprComponentImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new DaprComponentInner();
        this.serviceManager = serviceManager;
        this.componentName = name;
    }

    @Override
    public DaprComponentImpl update() {
        return this;
    }

    @Override
    public DaprComponent apply() {
        this.innerObject = (DaprComponentInner)((Object)this.serviceManager.serviceClient().getDaprComponents().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprComponent apply(Context context) {
        this.innerObject = (DaprComponentInner)((Object)this.serviceManager.serviceClient().getDaprComponents().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.innerModel(), context).getValue());
        return this;
    }

    DaprComponentImpl(DaprComponentInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.componentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "daprComponents");
    }

    @Override
    public DaprComponent refresh() {
        this.innerObject = (DaprComponentInner)((Object)this.serviceManager.serviceClient().getDaprComponents().getWithResponse(this.resourceGroupName, this.environmentName, this.componentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprComponent refresh(Context context) {
        this.innerObject = (DaprComponentInner)((Object)this.serviceManager.serviceClient().getDaprComponents().getWithResponse(this.resourceGroupName, this.environmentName, this.componentName, context).getValue());
        return this;
    }

    @Override
    public Response<DaprSecretsCollection> listSecretsWithResponse(Context context) {
        return this.serviceManager.daprComponents().listSecretsWithResponse(this.resourceGroupName, this.environmentName, this.componentName, context);
    }

    @Override
    public DaprSecretsCollection listSecrets() {
        return this.serviceManager.daprComponents().listSecrets(this.resourceGroupName, this.environmentName, this.componentName);
    }

    @Override
    public DaprComponentImpl withComponentType(String componentType) {
        this.innerModel().withComponentType(componentType);
        return this;
    }

    @Override
    public DaprComponentImpl withVersion(String version) {
        this.innerModel().withVersion(version);
        return this;
    }

    @Override
    public DaprComponentImpl withIgnoreErrors(Boolean ignoreErrors) {
        this.innerModel().withIgnoreErrors(ignoreErrors);
        return this;
    }

    @Override
    public DaprComponentImpl withInitTimeout(String initTimeout) {
        this.innerModel().withInitTimeout(initTimeout);
        return this;
    }

    @Override
    public DaprComponentImpl withSecrets(List<Secret> secrets) {
        this.innerModel().withSecrets(secrets);
        return this;
    }

    @Override
    public DaprComponentImpl withSecretStoreComponent(String secretStoreComponent) {
        this.innerModel().withSecretStoreComponent(secretStoreComponent);
        return this;
    }

    @Override
    public DaprComponentImpl withMetadata(List<DaprMetadata> metadata) {
        this.innerModel().withMetadata(metadata);
        return this;
    }

    @Override
    public DaprComponentImpl withScopes(List<String> scopes) {
        this.innerModel().withScopes(scopes);
        return this;
    }

    @Override
    public DaprComponentImpl withServiceComponentBind(List<DaprComponentServiceBinding> serviceComponentBind) {
        this.innerModel().withServiceComponentBind(serviceComponentBind);
        return this;
    }
}

