/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsSourceControlsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.SourceControlInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.implementation.SourceControlImpl;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsSourceControls;
import com.azure.resourcemanager.appcontainers.models.SourceControl;

public final class ContainerAppsSourceControlsImpl
implements ContainerAppsSourceControls {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsSourceControlsImpl.class);
    private final ContainerAppsSourceControlsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsSourceControlsImpl(ContainerAppsSourceControlsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SourceControl> listByContainerApp(String resourceGroupName, String containerAppName) {
        PagedIterable<SourceControlInner> inner = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlImpl((SourceControlInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SourceControl> listByContainerApp(String resourceGroupName, String containerAppName, Context context) {
        PagedIterable<SourceControlInner> inner = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlImpl((SourceControlInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SourceControl> getWithResponse(String resourceGroupName, String containerAppName, String sourceControlName, Context context) {
        Response<SourceControlInner> inner = this.serviceClient().getWithResponse(resourceGroupName, containerAppName, sourceControlName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SourceControlImpl((SourceControlInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SourceControl get(String resourceGroupName, String containerAppName, String sourceControlName) {
        SourceControlInner inner = this.serviceClient().get(resourceGroupName, containerAppName, sourceControlName);
        if (inner != null) {
            return new SourceControlImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String containerAppName, String sourceControlName) {
        this.serviceClient().delete(resourceGroupName, containerAppName, sourceControlName);
    }

    @Override
    public void delete(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow, Context context) {
        this.serviceClient().delete(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow, context);
    }

    @Override
    public SourceControl getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourcecontrols");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourcecontrols'.", id)));
        }
        return (SourceControl)this.getWithResponse(resourceGroupName, containerAppName, sourceControlName, Context.NONE).getValue();
    }

    @Override
    public Response<SourceControl> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourcecontrols");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourcecontrols'.", id)));
        }
        return this.getWithResponse(resourceGroupName, containerAppName, sourceControlName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourcecontrols");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourcecontrols'.", id)));
        }
        String localXMsGithubAuxiliary = null;
        Boolean localIgnoreWorkflowDeletionFailure = null;
        Boolean localDeleteWorkflow = null;
        this.delete(resourceGroupName, containerAppName, sourceControlName, localXMsGithubAuxiliary, localIgnoreWorkflowDeletionFailure, localDeleteWorkflow, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourcecontrols");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourcecontrols'.", id)));
        }
        this.delete(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow, context);
    }

    private ContainerAppsSourceControlsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public SourceControlImpl define(String name) {
        return new SourceControlImpl(name, this.manager());
    }
}

