/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsSourceControlsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.SourceControlInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appcontainers.models.SourceControlCollection;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ContainerAppsSourceControlsClientImpl
implements ContainerAppsSourceControlsClient {
    private final ContainerAppsSourceControlsService service;
    private final ContainerAppsApiClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsSourceControlsClientImpl.class);

    ContainerAppsSourceControlsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ContainerAppsSourceControlsService)RestProxy.create(ContainerAppsSourceControlsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlInner>> listByContainerAppSinglePageAsync(String resourceGroupName, String containerAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByContainerApp(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlCollection)res.getValue()).value(), ((SourceControlCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SourceControlInner> listByContainerAppAsync(String resourceGroupName, String containerAppName) {
        return new PagedFlux(() -> this.listByContainerAppSinglePageAsync(resourceGroupName, containerAppName), nextLink -> this.listByContainerAppNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SourceControlInner> listByContainerAppSinglePage(String resourceGroupName, String containerAppName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SourceControlCollection> res = this.service.listByContainerAppSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlCollection)res.getValue()).value(), ((SourceControlCollection)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SourceControlInner> listByContainerAppSinglePage(String resourceGroupName, String containerAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SourceControlCollection> res = this.service.listByContainerAppSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlCollection)res.getValue()).value(), ((SourceControlCollection)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SourceControlInner> listByContainerApp(String resourceGroupName, String containerAppName) {
        return new PagedIterable(() -> this.listByContainerAppSinglePage(resourceGroupName, containerAppName), nextLink -> this.listByContainerAppNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SourceControlInner> listByContainerApp(String resourceGroupName, String containerAppName, Context context) {
        return new PagedIterable(() -> this.listByContainerAppSinglePage(resourceGroupName, containerAppName, context), nextLink -> this.listByContainerAppNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceControlInner>> getWithResponseAsync(String resourceGroupName, String containerAppName, String sourceControlName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SourceControlInner> getAsync(String resourceGroupName, String containerAppName, String sourceControlName) {
        return this.getWithResponseAsync(resourceGroupName, containerAppName, sourceControlName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SourceControlInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SourceControlInner> getWithResponse(String resourceGroupName, String containerAppName, String sourceControlName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SourceControlInner get(String resourceGroupName, String containerAppName, String sourceControlName) {
        return (SourceControlInner)((Object)this.getWithResponse(resourceGroupName, containerAppName, sourceControlName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlEnvelope is required and cannot be null."));
        }
        sourceControlEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, this.client.getApiVersion(), sourceControlEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlEnvelope == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sourceControlEnvelope is required and cannot be null."));
        }
        sourceControlEnvelope.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, this.client.getApiVersion(), sourceControlEnvelope, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlEnvelope == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sourceControlEnvelope is required and cannot be null."));
        }
        sourceControlEnvelope.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, this.client.getApiVersion(), sourceControlEnvelope, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SourceControlInner>, SourceControlInner> beginCreateOrUpdateAsync(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SourceControlInner.class), (Type)((Object)SourceControlInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SourceControlInner>, SourceControlInner> beginCreateOrUpdateAsync(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope) {
        String xMsGithubAuxiliary = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SourceControlInner.class), (Type)((Object)SourceControlInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SourceControlInner>, SourceControlInner> beginCreateOrUpdate(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary);
        return this.client.getLroResult(response, (Type)((Object)SourceControlInner.class), (Type)((Object)SourceControlInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SourceControlInner>, SourceControlInner> beginCreateOrUpdate(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope) {
        String xMsGithubAuxiliary = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary);
        return this.client.getLroResult(response, (Type)((Object)SourceControlInner.class), (Type)((Object)SourceControlInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SourceControlInner>, SourceControlInner> beginCreateOrUpdate(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary, context);
        return this.client.getLroResult(response, (Type)((Object)SourceControlInner.class), (Type)((Object)SourceControlInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SourceControlInner> createOrUpdateAsync(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SourceControlInner> createOrUpdateAsync(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope) {
        String xMsGithubAuxiliary = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SourceControlInner createOrUpdate(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope) {
        String xMsGithubAuxiliary = null;
        return (SourceControlInner)((Object)this.beginCreateOrUpdate(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SourceControlInner createOrUpdate(String resourceGroupName, String containerAppName, String sourceControlName, SourceControlInner sourceControlEnvelope, String xMsGithubAuxiliary, Context context) {
        return (SourceControlInner)((Object)this.beginCreateOrUpdate(resourceGroupName, containerAppName, sourceControlName, sourceControlEnvelope, xMsGithubAuxiliary, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String containerAppName, String sourceControlName) {
        String xMsGithubAuxiliary = null;
        Boolean ignoreWorkflowDeletionFailure = null;
        Boolean deleteWorkflow = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String containerAppName, String sourceControlName) {
        String xMsGithubAuxiliary = null;
        Boolean ignoreWorkflowDeletionFailure = null;
        Boolean deleteWorkflow = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow) {
        return this.beginDeleteAsync(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String containerAppName, String sourceControlName) {
        String xMsGithubAuxiliary = null;
        Boolean ignoreWorkflowDeletionFailure = null;
        Boolean deleteWorkflow = null;
        return this.beginDeleteAsync(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String containerAppName, String sourceControlName) {
        String xMsGithubAuxiliary = null;
        Boolean ignoreWorkflowDeletionFailure = null;
        Boolean deleteWorkflow = null;
        this.beginDelete(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String containerAppName, String sourceControlName, String xMsGithubAuxiliary, Boolean ignoreWorkflowDeletionFailure, Boolean deleteWorkflow, Context context) {
        this.beginDelete(resourceGroupName, containerAppName, sourceControlName, xMsGithubAuxiliary, ignoreWorkflowDeletionFailure, deleteWorkflow, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlInner>> listByContainerAppNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByContainerAppNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlCollection)res.getValue()).value(), ((SourceControlCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SourceControlInner> listByContainerAppNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SourceControlCollection> res = this.service.listByContainerAppNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlCollection)res.getValue()).value(), ((SourceControlCollection)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SourceControlInner> listByContainerAppNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SourceControlCollection> res = this.service.listByContainerAppNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlCollection)res.getValue()).value(), ((SourceControlCollection)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClientContainerAppsSourceControls")
    public static interface ContainerAppsSourceControlsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<SourceControlCollection>> listByContainerApp(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<SourceControlCollection> listByContainerAppSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<SourceControlInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="sourceControlName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<SourceControlInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="sourceControlName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="sourceControlName") String var5, @HeaderParam(value="x-ms-github-auxiliary") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") SourceControlInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="sourceControlName") String var5, @HeaderParam(value="x-ms-github-auxiliary") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") SourceControlInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="sourceControlName") String var5, @HeaderParam(value="x-ms-github-auxiliary") String var6, @QueryParam(value="ignoreWorkflowDeletionFailure") Boolean var7, @QueryParam(value="deleteWorkflow") Boolean var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="sourceControlName") String var5, @HeaderParam(value="x-ms-github-auxiliary") String var6, @QueryParam(value="ignoreWorkflowDeletionFailure") Boolean var7, @QueryParam(value="deleteWorkflow") Boolean var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<SourceControlCollection>> listByContainerAppNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<SourceControlCollection> listByContainerAppNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

