/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsLabelHistoriesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.LabelHistoryInner;
import com.azure.resourcemanager.appcontainers.implementation.LabelHistoryImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsLabelHistories;
import com.azure.resourcemanager.appcontainers.models.LabelHistory;

public final class ContainerAppsLabelHistoriesImpl
implements ContainerAppsLabelHistories {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsLabelHistoriesImpl.class);
    private final ContainerAppsLabelHistoriesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsLabelHistoriesImpl(ContainerAppsLabelHistoriesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LabelHistory> listLabelHistory(String resourceGroupName, String containerAppName) {
        PagedIterable<LabelHistoryInner> inner = this.serviceClient().listLabelHistory(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LabelHistoryImpl((LabelHistoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LabelHistory> listLabelHistory(String resourceGroupName, String containerAppName, String filter, Context context) {
        PagedIterable<LabelHistoryInner> inner = this.serviceClient().listLabelHistory(resourceGroupName, containerAppName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LabelHistoryImpl((LabelHistoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<LabelHistory> getLabelHistoryWithResponse(String resourceGroupName, String containerAppName, String labelName, Context context) {
        Response<LabelHistoryInner> inner = this.serviceClient().getLabelHistoryWithResponse(resourceGroupName, containerAppName, labelName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LabelHistoryImpl((LabelHistoryInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public LabelHistory getLabelHistory(String resourceGroupName, String containerAppName, String labelName) {
        LabelHistoryInner inner = this.serviceClient().getLabelHistory(resourceGroupName, containerAppName, labelName);
        if (inner != null) {
            return new LabelHistoryImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteLabelHistoryWithResponse(String resourceGroupName, String containerAppName, String labelName, Context context) {
        return this.serviceClient().deleteLabelHistoryWithResponse(resourceGroupName, containerAppName, labelName, context);
    }

    @Override
    public void deleteLabelHistory(String resourceGroupName, String containerAppName, String labelName) {
        this.serviceClient().deleteLabelHistory(resourceGroupName, containerAppName, labelName);
    }

    private ContainerAppsLabelHistoriesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

