/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsDaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentDaprComponentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentDaprComponentsCollection;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConnectedEnvironmentsDaprComponentsClientImpl
implements ConnectedEnvironmentsDaprComponentsClient {
    private final ConnectedEnvironmentsDaprComponentsService service;
    private final ContainerAppsApiClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectedEnvironmentsDaprComponentsClientImpl.class);

    ConnectedEnvironmentsDaprComponentsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ConnectedEnvironmentsDaprComponentsService)RestProxy.create(ConnectedEnvironmentsDaprComponentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedEnvironmentDaprComponentInner>> listSinglePageAsync(String resourceGroupName, String connectedEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).value(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConnectedEnvironmentDaprComponentInner> listAsync(String resourceGroupName, String connectedEnvironmentName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, connectedEnvironmentName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConnectedEnvironmentDaprComponentInner> listSinglePage(String resourceGroupName, String connectedEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConnectedEnvironmentDaprComponentsCollection> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).value(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConnectedEnvironmentDaprComponentInner> listSinglePage(String resourceGroupName, String connectedEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConnectedEnvironmentDaprComponentsCollection> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).value(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectedEnvironmentDaprComponentInner> list(String resourceGroupName, String connectedEnvironmentName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, connectedEnvironmentName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectedEnvironmentDaprComponentInner> list(String resourceGroupName, String connectedEnvironmentName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, connectedEnvironmentName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentDaprComponentInner>> getWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentDaprComponentInner> getAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return this.getWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConnectedEnvironmentDaprComponentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectedEnvironmentDaprComponentInner> getWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentDaprComponentInner get(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return (ConnectedEnvironmentDaprComponentInner)((Object)this.getWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        if (daprComponentEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter daprComponentEnvelope is required and cannot be null."));
        }
        daprComponentEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), daprComponentEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        if (daprComponentEnvelope == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter daprComponentEnvelope is required and cannot be null."));
        }
        daprComponentEnvelope.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), daprComponentEnvelope, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        if (daprComponentEnvelope == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter daprComponentEnvelope is required and cannot be null."));
        }
        daprComponentEnvelope.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), daprComponentEnvelope, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectedEnvironmentDaprComponentInner>, ConnectedEnvironmentDaprComponentInner> beginCreateOrUpdateAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConnectedEnvironmentDaprComponentInner.class), (Type)((Object)ConnectedEnvironmentDaprComponentInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedEnvironmentDaprComponentInner>, ConnectedEnvironmentDaprComponentInner> beginCreateOrUpdate(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope);
        return this.client.getLroResult(response, (Type)((Object)ConnectedEnvironmentDaprComponentInner.class), (Type)((Object)ConnectedEnvironmentDaprComponentInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedEnvironmentDaprComponentInner>, ConnectedEnvironmentDaprComponentInner> beginCreateOrUpdate(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope, context);
        return this.client.getLroResult(response, (Type)((Object)ConnectedEnvironmentDaprComponentInner.class), (Type)((Object)ConnectedEnvironmentDaprComponentInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentDaprComponentInner> createOrUpdateAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentDaprComponentInner createOrUpdate(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope) {
        return (ConnectedEnvironmentDaprComponentInner)((Object)this.beginCreateOrUpdate(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentDaprComponentInner createOrUpdate(String resourceGroupName, String connectedEnvironmentName, String componentName, ConnectedEnvironmentDaprComponentInner daprComponentEnvelope, Context context) {
        return (ConnectedEnvironmentDaprComponentInner)((Object)this.beginCreateOrUpdate(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, componentName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, componentName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return this.beginDeleteAsync(resourceGroupName, connectedEnvironmentName, componentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        this.beginDelete(resourceGroupName, connectedEnvironmentName, componentName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        this.beginDelete(resourceGroupName, connectedEnvironmentName, componentName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DaprSecretsCollectionInner>> listSecretsWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSecrets(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DaprSecretsCollectionInner> listSecretsAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return this.listSecretsWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName).flatMap(res -> Mono.justOrEmpty((Object)((DaprSecretsCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DaprSecretsCollectionInner> listSecretsWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.listSecretsSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DaprSecretsCollectionInner listSecrets(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return (DaprSecretsCollectionInner)this.listSecretsWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedEnvironmentDaprComponentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).value(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConnectedEnvironmentDaprComponentInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConnectedEnvironmentDaprComponentsCollection> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).value(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConnectedEnvironmentDaprComponentInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConnectedEnvironmentDaprComponentsCollection> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).value(), ((ConnectedEnvironmentDaprComponentsCollection)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClientConnectedEnvironmentsDaprComponents")
    public static interface ConnectedEnvironmentsDaprComponentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentDaprComponentsCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<ConnectedEnvironmentDaprComponentsCollection> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentDaprComponentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<ConnectedEnvironmentDaprComponentInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConnectedEnvironmentDaprComponentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConnectedEnvironmentDaprComponentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}/listSecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DaprSecretsCollectionInner>> listSecrets(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}/listSecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<DaprSecretsCollectionInner> listSecretsSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentDaprComponentsCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<ConnectedEnvironmentDaprComponentsCollection> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

