/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentDaprComponentInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentDaprComponent;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentDaprComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DaprComponentServiceBinding;
import com.azure.resourcemanager.appcontainers.models.DaprMetadata;
import com.azure.resourcemanager.appcontainers.models.DaprSecretsCollection;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.util.Collections;
import java.util.List;

public final class ConnectedEnvironmentDaprComponentImpl
implements ConnectedEnvironmentDaprComponent,
ConnectedEnvironmentDaprComponent.Definition,
ConnectedEnvironmentDaprComponent.Update {
    private ConnectedEnvironmentDaprComponentInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String connectedEnvironmentName;
    private String componentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ConnectedEnvironmentDaprComponentProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String deploymentErrors() {
        return this.innerModel().deploymentErrors();
    }

    @Override
    public String componentType() {
        return this.innerModel().componentType();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public Boolean ignoreErrors() {
        return this.innerModel().ignoreErrors();
    }

    @Override
    public String initTimeout() {
        return this.innerModel().initTimeout();
    }

    @Override
    public List<Secret> secrets() {
        List<Secret> inner = this.innerModel().secrets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String secretStoreComponent() {
        return this.innerModel().secretStoreComponent();
    }

    @Override
    public List<DaprMetadata> metadata() {
        List<DaprMetadata> inner = this.innerModel().metadata();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> scopes() {
        List<String> inner = this.innerModel().scopes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DaprComponentServiceBinding> serviceComponentBind() {
        List<DaprComponentServiceBinding> inner = this.innerModel().serviceComponentBind();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConnectedEnvironmentDaprComponentInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withExistingConnectedEnvironment(String resourceGroupName, String connectedEnvironmentName) {
        this.resourceGroupName = resourceGroupName;
        this.connectedEnvironmentName = connectedEnvironmentName;
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponent create() {
        this.innerObject = this.serviceManager.serviceClient().getConnectedEnvironmentsDaprComponents().createOrUpdate(this.resourceGroupName, this.connectedEnvironmentName, this.componentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponent create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConnectedEnvironmentsDaprComponents().createOrUpdate(this.resourceGroupName, this.connectedEnvironmentName, this.componentName, this.innerModel(), context);
        return this;
    }

    ConnectedEnvironmentDaprComponentImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new ConnectedEnvironmentDaprComponentInner();
        this.serviceManager = serviceManager;
        this.componentName = name;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl update() {
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponent apply() {
        this.innerObject = this.serviceManager.serviceClient().getConnectedEnvironmentsDaprComponents().createOrUpdate(this.resourceGroupName, this.connectedEnvironmentName, this.componentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponent apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConnectedEnvironmentsDaprComponents().createOrUpdate(this.resourceGroupName, this.connectedEnvironmentName, this.componentName, this.innerModel(), context);
        return this;
    }

    ConnectedEnvironmentDaprComponentImpl(ConnectedEnvironmentDaprComponentInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.connectedEnvironmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connectedEnvironments");
        this.componentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "daprComponents");
    }

    @Override
    public ConnectedEnvironmentDaprComponent refresh() {
        this.innerObject = (ConnectedEnvironmentDaprComponentInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsDaprComponents().getWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.componentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponent refresh(Context context) {
        this.innerObject = (ConnectedEnvironmentDaprComponentInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsDaprComponents().getWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.componentName, context).getValue());
        return this;
    }

    @Override
    public Response<DaprSecretsCollection> listSecretsWithResponse(Context context) {
        return this.serviceManager.connectedEnvironmentsDaprComponents().listSecretsWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.componentName, context);
    }

    @Override
    public DaprSecretsCollection listSecrets() {
        return this.serviceManager.connectedEnvironmentsDaprComponents().listSecrets(this.resourceGroupName, this.connectedEnvironmentName, this.componentName);
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withComponentType(String componentType) {
        this.innerModel().withComponentType(componentType);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withVersion(String version) {
        this.innerModel().withVersion(version);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withIgnoreErrors(Boolean ignoreErrors) {
        this.innerModel().withIgnoreErrors(ignoreErrors);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withInitTimeout(String initTimeout) {
        this.innerModel().withInitTimeout(initTimeout);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withSecrets(List<Secret> secrets) {
        this.innerModel().withSecrets(secrets);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withSecretStoreComponent(String secretStoreComponent) {
        this.innerModel().withSecretStoreComponent(secretStoreComponent);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withMetadata(List<DaprMetadata> metadata) {
        this.innerModel().withMetadata(metadata);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withScopes(List<String> scopes) {
        this.innerModel().withScopes(scopes);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentImpl withServiceComponentBind(List<DaprComponentServiceBinding> serviceComponentBind) {
        this.innerModel().withServiceComponentBind(serviceComponentBind);
        return this;
    }
}

