/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.BuildsByBuilderResourcesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;
import com.azure.resourcemanager.appcontainers.implementation.BuildResourceImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.BuildResource;
import com.azure.resourcemanager.appcontainers.models.BuildsByBuilderResources;

public final class BuildsByBuilderResourcesImpl
implements BuildsByBuilderResources {
    private static final ClientLogger LOGGER = new ClientLogger(BuildsByBuilderResourcesImpl.class);
    private final BuildsByBuilderResourcesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public BuildsByBuilderResourcesImpl(BuildsByBuilderResourcesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BuildResource> list(String resourceGroupName, String builderName) {
        PagedIterable<BuildResourceInner> inner = this.serviceClient().list(resourceGroupName, builderName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BuildResourceImpl((BuildResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BuildResource> list(String resourceGroupName, String builderName, Context context) {
        PagedIterable<BuildResourceInner> inner = this.serviceClient().list(resourceGroupName, builderName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BuildResourceImpl((BuildResourceInner)((Object)inner1), this.manager()));
    }

    private BuildsByBuilderResourcesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

