/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuilderResource;
import com.azure.resourcemanager.appcontainers.models.BuilderResourceUpdate;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BuilderResourceImpl
implements BuilderResource,
BuilderResource.Definition,
BuilderResource.Update {
    private BuilderResourceInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String builderName;
    private BuilderResourceUpdate updateBuilderEnvelope;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public BuilderProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String environmentId() {
        return this.innerModel().environmentId();
    }

    @Override
    public List<ContainerRegistry> containerRegistries() {
        List<ContainerRegistry> inner = this.innerModel().containerRegistries();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BuilderResourceInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public BuilderResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public BuilderResource create() {
        this.innerObject = this.serviceManager.serviceClient().getBuilders().createOrUpdate(this.resourceGroupName, this.builderName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BuilderResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBuilders().createOrUpdate(this.resourceGroupName, this.builderName, this.innerModel(), context);
        return this;
    }

    BuilderResourceImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new BuilderResourceInner();
        this.serviceManager = serviceManager;
        this.builderName = name;
    }

    @Override
    public BuilderResourceImpl update() {
        this.updateBuilderEnvelope = new BuilderResourceUpdate();
        return this;
    }

    @Override
    public BuilderResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getBuilders().update(this.resourceGroupName, this.builderName, this.updateBuilderEnvelope, Context.NONE);
        return this;
    }

    @Override
    public BuilderResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBuilders().update(this.resourceGroupName, this.builderName, this.updateBuilderEnvelope, context);
        return this;
    }

    BuilderResourceImpl(BuilderResourceInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.builderName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "builders");
    }

    @Override
    public BuilderResource refresh() {
        this.innerObject = (BuilderResourceInner)((Object)this.serviceManager.serviceClient().getBuilders().getByResourceGroupWithResponse(this.resourceGroupName, this.builderName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BuilderResource refresh(Context context) {
        this.innerObject = (BuilderResourceInner)((Object)this.serviceManager.serviceClient().getBuilders().getByResourceGroupWithResponse(this.resourceGroupName, this.builderName, context).getValue());
        return this;
    }

    @Override
    public BuilderResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BuilderResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BuilderResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBuilderEnvelope.withTags(tags);
        return this;
    }

    @Override
    public BuilderResourceImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateBuilderEnvelope.withIdentity(identity);
        return this;
    }

    @Override
    public BuilderResourceImpl withEnvironmentId(String environmentId) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnvironmentId(environmentId);
            return this;
        }
        this.updateBuilderEnvelope.withEnvironmentId(environmentId);
        return this;
    }

    @Override
    public BuilderResourceImpl withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.innerModel().withContainerRegistries(containerRegistries);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

