/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.BuildAuthTokensClient;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildTokenInner;
import com.azure.resourcemanager.appcontainers.implementation.BuildTokenImpl;
import com.azure.resourcemanager.appcontainers.models.BuildAuthTokens;
import com.azure.resourcemanager.appcontainers.models.BuildToken;

public final class BuildAuthTokensImpl
implements BuildAuthTokens {
    private static final ClientLogger LOGGER = new ClientLogger(BuildAuthTokensImpl.class);
    private final BuildAuthTokensClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public BuildAuthTokensImpl(BuildAuthTokensClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BuildToken> listWithResponse(String resourceGroupName, String builderName, String buildName, Context context) {
        Response<BuildTokenInner> inner = this.serviceClient().listWithResponse(resourceGroupName, builderName, buildName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BuildTokenImpl((BuildTokenInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BuildToken list(String resourceGroupName, String builderName, String buildName) {
        BuildTokenInner inner = this.serviceClient().list(resourceGroupName, builderName, buildName);
        if (inner != null) {
            return new BuildTokenImpl(inner, this.manager());
        }
        return null;
    }

    private BuildAuthTokensClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

