/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.WorkflowEnvelopeProperties;
import java.io.IOException;

public final class WorkflowEnvelopeInner
implements JsonSerializable<WorkflowEnvelopeInner> {
    private String id;
    private String name;
    private String type;
    private String kind;
    private String location;
    private WorkflowEnvelopeProperties properties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String kind() {
        return this.kind;
    }

    public WorkflowEnvelopeInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String location() {
        return this.location;
    }

    public WorkflowEnvelopeInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public WorkflowEnvelopeProperties properties() {
        return this.properties;
    }

    public WorkflowEnvelopeInner withProperties(WorkflowEnvelopeProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowEnvelopeInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowEnvelopeInner)jsonReader.readObject(reader -> {
            WorkflowEnvelopeInner deserializedWorkflowEnvelopeInner = new WorkflowEnvelopeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.kind = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.properties = WorkflowEnvelopeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowEnvelopeInner;
        });
    }
}

