/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.RevisionHealthState;
import com.azure.resourcemanager.appcontainers.models.RevisionProvisioningState;
import com.azure.resourcemanager.appcontainers.models.RevisionRunningState;
import com.azure.resourcemanager.appcontainers.models.Template;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RevisionProperties
implements JsonSerializable<RevisionProperties> {
    private OffsetDateTime createdTime;
    private OffsetDateTime lastActiveTime;
    private String fqdn;
    private Template template;
    private Boolean active;
    private Integer replicas;
    private Integer trafficWeight;
    private List<String> labels;
    private String provisioningError;
    private RevisionHealthState healthState;
    private RevisionProvisioningState provisioningState;
    private RevisionRunningState runningState;

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime lastActiveTime() {
        return this.lastActiveTime;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public Template template() {
        return this.template;
    }

    public Boolean active() {
        return this.active;
    }

    public Integer replicas() {
        return this.replicas;
    }

    public Integer trafficWeight() {
        return this.trafficWeight;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String provisioningError() {
        return this.provisioningError;
    }

    public RevisionHealthState healthState() {
        return this.healthState;
    }

    public RevisionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public RevisionRunningState runningState() {
        return this.runningState;
    }

    public void validate() {
        if (this.template() != null) {
            this.template().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RevisionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RevisionProperties)jsonReader.readObject(reader -> {
            RevisionProperties deserializedRevisionProperties = new RevisionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdTime".equals(fieldName)) {
                    deserializedRevisionProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastActiveTime".equals(fieldName)) {
                    deserializedRevisionProperties.lastActiveTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedRevisionProperties.fqdn = reader.getString();
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedRevisionProperties.template = Template.fromJson(reader);
                    continue;
                }
                if ("active".equals(fieldName)) {
                    deserializedRevisionProperties.active = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("replicas".equals(fieldName)) {
                    deserializedRevisionProperties.replicas = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("trafficWeight".equals(fieldName)) {
                    deserializedRevisionProperties.trafficWeight = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedRevisionProperties.labels = labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedRevisionProperties.provisioningError = reader.getString();
                    continue;
                }
                if ("healthState".equals(fieldName)) {
                    deserializedRevisionProperties.healthState = RevisionHealthState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRevisionProperties.provisioningState = RevisionProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("runningState".equals(fieldName)) {
                    deserializedRevisionProperties.runningState = RevisionRunningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRevisionProperties;
        });
    }
}

