/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.io.IOException;
import java.util.List;

public final class JobSecretsCollectionInner
implements JsonSerializable<JobSecretsCollectionInner> {
    private List<Secret> value;
    private static final ClientLogger LOGGER = new ClientLogger(JobSecretsCollectionInner.class);

    public List<Secret> value() {
        return this.value;
    }

    public JobSecretsCollectionInner withValue(List<Secret> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model JobSecretsCollectionInner"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobSecretsCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobSecretsCollectionInner)jsonReader.readObject(reader -> {
            JobSecretsCollectionInner deserializedJobSecretsCollectionInner = new JobSecretsCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedJobSecretsCollectionInner.value = value = reader.readArray(reader1 -> Secret.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobSecretsCollectionInner;
        });
    }
}

