/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.HeaderMatch;
import java.io.IOException;
import java.util.List;

public final class HttpRetryPolicyMatches
implements JsonSerializable<HttpRetryPolicyMatches> {
    private List<HeaderMatch> headers;
    private List<Integer> httpStatusCodes;
    private List<String> errors;

    public List<HeaderMatch> headers() {
        return this.headers;
    }

    public HttpRetryPolicyMatches withHeaders(List<HeaderMatch> headers) {
        this.headers = headers;
        return this;
    }

    public List<Integer> httpStatusCodes() {
        return this.httpStatusCodes;
    }

    public HttpRetryPolicyMatches withHttpStatusCodes(List<Integer> httpStatusCodes) {
        this.httpStatusCodes = httpStatusCodes;
        return this;
    }

    public List<String> errors() {
        return this.errors;
    }

    public HttpRetryPolicyMatches withErrors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public void validate() {
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("httpStatusCodes", this.httpStatusCodes, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static HttpRetryPolicyMatches fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRetryPolicyMatches)jsonReader.readObject(reader -> {
            HttpRetryPolicyMatches deserializedHttpRetryPolicyMatches = new HttpRetryPolicyMatches();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedHttpRetryPolicyMatches.headers = headers = reader.readArray(reader1 -> HeaderMatch.fromJson(reader1));
                    continue;
                }
                if ("httpStatusCodes".equals(fieldName)) {
                    List httpStatusCodes;
                    deserializedHttpRetryPolicyMatches.httpStatusCodes = httpStatusCodes = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedHttpRetryPolicyMatches.errors = errors = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRetryPolicyMatches;
        });
    }
}

