/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentType;
import java.io.IOException;
import java.util.List;

public final class DotNetComponentProperties
implements JsonSerializable<DotNetComponentProperties> {
    private DotNetComponentType componentType;
    private DotNetComponentProvisioningState provisioningState;
    private List<DotNetComponentConfigurationProperty> configurations;
    private List<DotNetComponentServiceBind> serviceBinds;

    public DotNetComponentType componentType() {
        return this.componentType;
    }

    public DotNetComponentProperties withComponentType(DotNetComponentType componentType) {
        this.componentType = componentType;
        return this;
    }

    public DotNetComponentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<DotNetComponentConfigurationProperty> configurations() {
        return this.configurations;
    }

    public DotNetComponentProperties withConfigurations(List<DotNetComponentConfigurationProperty> configurations) {
        this.configurations = configurations;
        return this;
    }

    public List<DotNetComponentServiceBind> serviceBinds() {
        return this.serviceBinds;
    }

    public DotNetComponentProperties withServiceBinds(List<DotNetComponentServiceBind> serviceBinds) {
        this.serviceBinds = serviceBinds;
        return this;
    }

    public void validate() {
        if (this.configurations() != null) {
            this.configurations().forEach(e -> e.validate());
        }
        if (this.serviceBinds() != null) {
            this.serviceBinds().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("componentType", this.componentType == null ? null : this.componentType.toString());
        jsonWriter.writeArrayField("configurations", this.configurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("serviceBinds", this.serviceBinds, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DotNetComponentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DotNetComponentProperties)jsonReader.readObject(reader -> {
            DotNetComponentProperties deserializedDotNetComponentProperties = new DotNetComponentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("componentType".equals(fieldName)) {
                    deserializedDotNetComponentProperties.componentType = DotNetComponentType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDotNetComponentProperties.provisioningState = DotNetComponentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    List configurations;
                    deserializedDotNetComponentProperties.configurations = configurations = reader.readArray(reader1 -> DotNetComponentConfigurationProperty.fromJson(reader1));
                    continue;
                }
                if ("serviceBinds".equals(fieldName)) {
                    List serviceBinds;
                    deserializedDotNetComponentProperties.serviceBinds = serviceBinds = reader.readArray(reader1 -> DotNetComponentServiceBind.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDotNetComponentProperties;
        });
    }
}

