/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentProperties;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentType;
import java.io.IOException;
import java.util.List;

public final class DotNetComponentInner
extends ProxyResource {
    private DotNetComponentProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private DotNetComponentProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DotNetComponentType componentType() {
        return this.innerProperties() == null ? null : this.innerProperties().componentType();
    }

    public DotNetComponentInner withComponentType(DotNetComponentType componentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DotNetComponentProperties();
        }
        this.innerProperties().withComponentType(componentType);
        return this;
    }

    public DotNetComponentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<DotNetComponentConfigurationProperty> configurations() {
        return this.innerProperties() == null ? null : this.innerProperties().configurations();
    }

    public DotNetComponentInner withConfigurations(List<DotNetComponentConfigurationProperty> configurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DotNetComponentProperties();
        }
        this.innerProperties().withConfigurations(configurations);
        return this;
    }

    public List<DotNetComponentServiceBind> serviceBinds() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBinds();
    }

    public DotNetComponentInner withServiceBinds(List<DotNetComponentServiceBind> serviceBinds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DotNetComponentProperties();
        }
        this.innerProperties().withServiceBinds(serviceBinds);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DotNetComponentInner fromJson(JsonReader jsonReader) throws IOException {
        return (DotNetComponentInner)((Object)jsonReader.readObject(reader -> {
            DotNetComponentInner deserializedDotNetComponentInner = new DotNetComponentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDotNetComponentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDotNetComponentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDotNetComponentInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDotNetComponentInner.innerProperties = DotNetComponentProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDotNetComponentInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDotNetComponentInner;
        }));
    }
}

