/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionBulkSubscribeOptions;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRoutes;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DaprSubscriptionProperties
implements JsonSerializable<DaprSubscriptionProperties> {
    private String pubsubName;
    private String topic;
    private String deadLetterTopic;
    private DaprSubscriptionRoutes routes;
    private List<String> scopes;
    private Map<String, String> metadata;
    private DaprSubscriptionBulkSubscribeOptions bulkSubscribe;

    public String pubsubName() {
        return this.pubsubName;
    }

    public DaprSubscriptionProperties withPubsubName(String pubsubName) {
        this.pubsubName = pubsubName;
        return this;
    }

    public String topic() {
        return this.topic;
    }

    public DaprSubscriptionProperties withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public String deadLetterTopic() {
        return this.deadLetterTopic;
    }

    public DaprSubscriptionProperties withDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
        return this;
    }

    public DaprSubscriptionRoutes routes() {
        return this.routes;
    }

    public DaprSubscriptionProperties withRoutes(DaprSubscriptionRoutes routes) {
        this.routes = routes;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public DaprSubscriptionProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public DaprSubscriptionProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public DaprSubscriptionBulkSubscribeOptions bulkSubscribe() {
        return this.bulkSubscribe;
    }

    public DaprSubscriptionProperties withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe) {
        this.bulkSubscribe = bulkSubscribe;
        return this;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().validate();
        }
        if (this.bulkSubscribe() != null) {
            this.bulkSubscribe().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("pubsubName", this.pubsubName);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeStringField("deadLetterTopic", this.deadLetterTopic);
        jsonWriter.writeJsonField("routes", (JsonSerializable)this.routes);
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("bulkSubscribe", (JsonSerializable)this.bulkSubscribe);
        return jsonWriter.writeEndObject();
    }

    public static DaprSubscriptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DaprSubscriptionProperties)jsonReader.readObject(reader -> {
            DaprSubscriptionProperties deserializedDaprSubscriptionProperties = new DaprSubscriptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pubsubName".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.pubsubName = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.topic = reader.getString();
                    continue;
                }
                if ("deadLetterTopic".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.deadLetterTopic = reader.getString();
                    continue;
                }
                if ("routes".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.routes = DaprSubscriptionRoutes.fromJson(reader);
                    continue;
                }
                if ("scopes".equals(fieldName)) {
                    List scopes;
                    deserializedDaprSubscriptionProperties.scopes = scopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedDaprSubscriptionProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("bulkSubscribe".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.bulkSubscribe = DaprSubscriptionBulkSubscribeOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprSubscriptionProperties;
        });
    }
}

