/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

public final class ContainerAppsBuildProperties
implements JsonSerializable<ContainerAppsBuildProperties> {
    private BuildProvisioningState provisioningState;
    private BuildStatus buildStatus;
    private ContainerRegistryWithCustomImage destinationContainerRegistry;
    private ContainerAppsBuildConfiguration configuration;
    private String logStreamEndpoint;

    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public BuildStatus buildStatus() {
        return this.buildStatus;
    }

    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.destinationContainerRegistry;
    }

    public ContainerAppsBuildConfiguration configuration() {
        return this.configuration;
    }

    public String logStreamEndpoint() {
        return this.logStreamEndpoint;
    }

    public void validate() {
        if (this.destinationContainerRegistry() != null) {
            this.destinationContainerRegistry().validate();
        }
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppsBuildProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerAppsBuildProperties)jsonReader.readObject(reader -> {
            ContainerAppsBuildProperties deserializedContainerAppsBuildProperties = new ContainerAppsBuildProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.provisioningState = BuildProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("buildStatus".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.buildStatus = BuildStatus.fromString(reader.getString());
                    continue;
                }
                if ("destinationContainerRegistry".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.destinationContainerRegistry = ContainerRegistryWithCustomImage.fromJson(reader);
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.configuration = ContainerAppsBuildConfiguration.fromJson(reader);
                    continue;
                }
                if ("logStreamEndpoint".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.logStreamEndpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppsBuildProperties;
        });
    }
}

