/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppProperties;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppPropertiesPatchingConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerAppRunningStatus;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.azure.resourcemanager.appcontainers.models.Kind;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.Template;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ContainerAppInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private ManagedServiceIdentity identity;
    private String managedBy;
    private Kind kind;
    private ContainerAppProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ContainerAppInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ContainerAppInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String managedBy() {
        return this.managedBy;
    }

    public ContainerAppInner withManagedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public ContainerAppInner withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    private ContainerAppProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ContainerAppInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ContainerAppInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ContainerAppProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ContainerAppRunningStatus runningStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().runningStatus();
    }

    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    public String managedEnvironmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedEnvironmentId();
    }

    public ContainerAppInner withManagedEnvironmentId(String managedEnvironmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withManagedEnvironmentId(managedEnvironmentId);
        return this;
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public ContainerAppInner withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public String workloadProfileName() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadProfileName();
    }

    public ContainerAppInner withWorkloadProfileName(String workloadProfileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    public ContainerAppPropertiesPatchingConfiguration patchingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().patchingConfiguration();
    }

    public ContainerAppInner withPatchingConfiguration(ContainerAppPropertiesPatchingConfiguration patchingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withPatchingConfiguration(patchingConfiguration);
        return this;
    }

    public String latestRevisionName() {
        return this.innerProperties() == null ? null : this.innerProperties().latestRevisionName();
    }

    public String latestReadyRevisionName() {
        return this.innerProperties() == null ? null : this.innerProperties().latestReadyRevisionName();
    }

    public String latestRevisionFqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().latestRevisionFqdn();
    }

    public String customDomainVerificationId() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomainVerificationId();
    }

    public Configuration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public ContainerAppInner withConfiguration(Configuration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public Template template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public ContainerAppInner withTemplate(Template template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundIpAddresses();
    }

    public String eventStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().eventStreamEndpoint();
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("managedBy", this.managedBy);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppInner fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerAppInner)((Object)jsonReader.readObject(reader -> {
            ContainerAppInner deserializedContainerAppInner = new ContainerAppInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerAppInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainerAppInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerAppInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContainerAppInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedContainerAppInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedContainerAppInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedContainerAppInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("managedBy".equals(fieldName)) {
                    deserializedContainerAppInner.managedBy = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedContainerAppInner.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContainerAppInner.innerProperties = ContainerAppProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedContainerAppInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppInner;
        }));
    }
}

