/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentProperties;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentDaprComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DaprComponentServiceBinding;
import com.azure.resourcemanager.appcontainers.models.DaprMetadata;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.io.IOException;
import java.util.List;

public final class ConnectedEnvironmentDaprComponentProperties
extends DaprComponentProperties {
    private ConnectedEnvironmentDaprComponentProvisioningState provisioningState;
    private String deploymentErrors;

    public ConnectedEnvironmentDaprComponentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withComponentType(String componentType) {
        super.withComponentType(componentType);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withIgnoreErrors(Boolean ignoreErrors) {
        super.withIgnoreErrors(ignoreErrors);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withInitTimeout(String initTimeout) {
        super.withInitTimeout(initTimeout);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withSecrets(List<Secret> secrets) {
        super.withSecrets(secrets);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withSecretStoreComponent(String secretStoreComponent) {
        super.withSecretStoreComponent(secretStoreComponent);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withMetadata(List<DaprMetadata> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withScopes(List<String> scopes) {
        super.withScopes(scopes);
        return this;
    }

    @Override
    public ConnectedEnvironmentDaprComponentProperties withServiceComponentBind(List<DaprComponentServiceBinding> serviceComponentBind) {
        super.withServiceComponentBind(serviceComponentBind);
        return this;
    }

    @Override
    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
        if (this.serviceComponentBind() != null) {
            this.serviceComponentBind().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("componentType", this.componentType());
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeBooleanField("ignoreErrors", this.ignoreErrors());
        jsonWriter.writeStringField("initTimeout", this.initTimeout());
        jsonWriter.writeArrayField("secrets", this.secrets(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("secretStoreComponent", this.secretStoreComponent());
        jsonWriter.writeArrayField("metadata", this.metadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("scopes", this.scopes(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("serviceComponentBind", this.serviceComponentBind(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ConnectedEnvironmentDaprComponentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedEnvironmentDaprComponentProperties)jsonReader.readObject(reader -> {
            ConnectedEnvironmentDaprComponentProperties deserializedConnectedEnvironmentDaprComponentProperties = new ConnectedEnvironmentDaprComponentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("componentType".equals(fieldName)) {
                    deserializedConnectedEnvironmentDaprComponentProperties.withComponentType(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedConnectedEnvironmentDaprComponentProperties.withVersion(reader.getString());
                    continue;
                }
                if ("ignoreErrors".equals(fieldName)) {
                    deserializedConnectedEnvironmentDaprComponentProperties.withIgnoreErrors((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("initTimeout".equals(fieldName)) {
                    deserializedConnectedEnvironmentDaprComponentProperties.withInitTimeout(reader.getString());
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets = reader.readArray(reader1 -> Secret.fromJson(reader1));
                    deserializedConnectedEnvironmentDaprComponentProperties.withSecrets(secrets);
                    continue;
                }
                if ("secretStoreComponent".equals(fieldName)) {
                    deserializedConnectedEnvironmentDaprComponentProperties.withSecretStoreComponent(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> DaprMetadata.fromJson(reader1));
                    deserializedConnectedEnvironmentDaprComponentProperties.withMetadata(metadata);
                    continue;
                }
                if ("scopes".equals(fieldName)) {
                    List scopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectedEnvironmentDaprComponentProperties.withScopes(scopes);
                    continue;
                }
                if ("serviceComponentBind".equals(fieldName)) {
                    List serviceComponentBind = reader.readArray(reader1 -> DaprComponentServiceBinding.fromJson(reader1));
                    deserializedConnectedEnvironmentDaprComponentProperties.withServiceComponentBind(serviceComponentBind);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedConnectedEnvironmentDaprComponentProperties.provisioningState = ConnectedEnvironmentDaprComponentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentErrors".equals(fieldName)) {
                    deserializedConnectedEnvironmentDaprComponentProperties.deploymentErrors = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectedEnvironmentDaprComponentProperties;
        });
    }
}

