/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import java.io.IOException;
import java.util.List;

public final class BuilderProperties
implements JsonSerializable<BuilderProperties> {
    private BuilderProvisioningState provisioningState;
    private String environmentId;
    private List<ContainerRegistry> containerRegistries;
    private static final ClientLogger LOGGER = new ClientLogger(BuilderProperties.class);

    public BuilderProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public BuilderProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public List<ContainerRegistry> containerRegistries() {
        return this.containerRegistries;
    }

    public BuilderProperties withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.containerRegistries = containerRegistries;
        return this;
    }

    public void validate() {
        if (this.environmentId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property environmentId in model BuilderProperties"));
        }
        if (this.containerRegistries() != null) {
            this.containerRegistries().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeArrayField("containerRegistries", this.containerRegistries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BuilderProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BuilderProperties)jsonReader.readObject(reader -> {
            BuilderProperties deserializedBuilderProperties = new BuilderProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("environmentId".equals(fieldName)) {
                    deserializedBuilderProperties.environmentId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBuilderProperties.provisioningState = BuilderProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("containerRegistries".equals(fieldName)) {
                    List containerRegistries;
                    deserializedBuilderProperties.containerRegistries = containerRegistries = reader.readArray(reader1 -> ContainerRegistry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuilderProperties;
        });
    }
}

