/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildProperties;
import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

public final class BuildResourceInner
extends ProxyResource {
    private BuildProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private BuildProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public BuildProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public BuildStatus buildStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().buildStatus();
    }

    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationContainerRegistry();
    }

    public BuildResourceInner withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuildProperties();
        }
        this.innerProperties().withDestinationContainerRegistry(destinationContainerRegistry);
        return this;
    }

    public BuildConfiguration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public BuildResourceInner withConfiguration(BuildConfiguration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuildProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public String uploadEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().uploadEndpoint();
    }

    public String logStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().logStreamEndpoint();
    }

    public String tokenEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().tokenEndpoint();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BuildResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (BuildResourceInner)((Object)jsonReader.readObject(reader -> {
            BuildResourceInner deserializedBuildResourceInner = new BuildResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBuildResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBuildResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBuildResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBuildResourceInner.innerProperties = BuildProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBuildResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildResourceInner;
        }));
    }
}

