/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CircuitBreakerPolicy;
import com.azure.resourcemanager.appcontainers.models.HttpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.HttpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TcpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.TcpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TimeoutPolicy;
import java.io.IOException;

public final class AppResiliencyProperties
implements JsonSerializable<AppResiliencyProperties> {
    private TimeoutPolicy timeoutPolicy;
    private HttpRetryPolicy httpRetryPolicy;
    private TcpRetryPolicy tcpRetryPolicy;
    private CircuitBreakerPolicy circuitBreakerPolicy;
    private HttpConnectionPool httpConnectionPool;
    private TcpConnectionPool tcpConnectionPool;

    public TimeoutPolicy timeoutPolicy() {
        return this.timeoutPolicy;
    }

    public AppResiliencyProperties withTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
        return this;
    }

    public HttpRetryPolicy httpRetryPolicy() {
        return this.httpRetryPolicy;
    }

    public AppResiliencyProperties withHttpRetryPolicy(HttpRetryPolicy httpRetryPolicy) {
        this.httpRetryPolicy = httpRetryPolicy;
        return this;
    }

    public TcpRetryPolicy tcpRetryPolicy() {
        return this.tcpRetryPolicy;
    }

    public AppResiliencyProperties withTcpRetryPolicy(TcpRetryPolicy tcpRetryPolicy) {
        this.tcpRetryPolicy = tcpRetryPolicy;
        return this;
    }

    public CircuitBreakerPolicy circuitBreakerPolicy() {
        return this.circuitBreakerPolicy;
    }

    public AppResiliencyProperties withCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy) {
        this.circuitBreakerPolicy = circuitBreakerPolicy;
        return this;
    }

    public HttpConnectionPool httpConnectionPool() {
        return this.httpConnectionPool;
    }

    public AppResiliencyProperties withHttpConnectionPool(HttpConnectionPool httpConnectionPool) {
        this.httpConnectionPool = httpConnectionPool;
        return this;
    }

    public TcpConnectionPool tcpConnectionPool() {
        return this.tcpConnectionPool;
    }

    public AppResiliencyProperties withTcpConnectionPool(TcpConnectionPool tcpConnectionPool) {
        this.tcpConnectionPool = tcpConnectionPool;
        return this;
    }

    public void validate() {
        if (this.timeoutPolicy() != null) {
            this.timeoutPolicy().validate();
        }
        if (this.httpRetryPolicy() != null) {
            this.httpRetryPolicy().validate();
        }
        if (this.tcpRetryPolicy() != null) {
            this.tcpRetryPolicy().validate();
        }
        if (this.circuitBreakerPolicy() != null) {
            this.circuitBreakerPolicy().validate();
        }
        if (this.httpConnectionPool() != null) {
            this.httpConnectionPool().validate();
        }
        if (this.tcpConnectionPool() != null) {
            this.tcpConnectionPool().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("timeoutPolicy", (JsonSerializable)this.timeoutPolicy);
        jsonWriter.writeJsonField("httpRetryPolicy", (JsonSerializable)this.httpRetryPolicy);
        jsonWriter.writeJsonField("tcpRetryPolicy", (JsonSerializable)this.tcpRetryPolicy);
        jsonWriter.writeJsonField("circuitBreakerPolicy", (JsonSerializable)this.circuitBreakerPolicy);
        jsonWriter.writeJsonField("httpConnectionPool", (JsonSerializable)this.httpConnectionPool);
        jsonWriter.writeJsonField("tcpConnectionPool", (JsonSerializable)this.tcpConnectionPool);
        return jsonWriter.writeEndObject();
    }

    public static AppResiliencyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AppResiliencyProperties)jsonReader.readObject(reader -> {
            AppResiliencyProperties deserializedAppResiliencyProperties = new AppResiliencyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeoutPolicy".equals(fieldName)) {
                    deserializedAppResiliencyProperties.timeoutPolicy = TimeoutPolicy.fromJson(reader);
                    continue;
                }
                if ("httpRetryPolicy".equals(fieldName)) {
                    deserializedAppResiliencyProperties.httpRetryPolicy = HttpRetryPolicy.fromJson(reader);
                    continue;
                }
                if ("tcpRetryPolicy".equals(fieldName)) {
                    deserializedAppResiliencyProperties.tcpRetryPolicy = TcpRetryPolicy.fromJson(reader);
                    continue;
                }
                if ("circuitBreakerPolicy".equals(fieldName)) {
                    deserializedAppResiliencyProperties.circuitBreakerPolicy = CircuitBreakerPolicy.fromJson(reader);
                    continue;
                }
                if ("httpConnectionPool".equals(fieldName)) {
                    deserializedAppResiliencyProperties.httpConnectionPool = HttpConnectionPool.fromJson(reader);
                    continue;
                }
                if ("tcpConnectionPool".equals(fieldName)) {
                    deserializedAppResiliencyProperties.tcpConnectionPool = TcpConnectionPool.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppResiliencyProperties;
        });
    }
}

