/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Container;
import com.azure.resourcemanager.appcontainers.models.InitContainer;
import com.azure.resourcemanager.appcontainers.models.Scale;
import com.azure.resourcemanager.appcontainers.models.ServiceBind;
import com.azure.resourcemanager.appcontainers.models.Volume;
import java.io.IOException;
import java.util.List;

public final class Template
implements JsonSerializable<Template> {
    private String revisionSuffix;
    private Long terminationGracePeriodSeconds;
    private List<InitContainer> initContainers;
    private List<Container> containers;
    private Scale scale;
    private List<Volume> volumes;
    private List<ServiceBind> serviceBinds;

    public String revisionSuffix() {
        return this.revisionSuffix;
    }

    public Template withRevisionSuffix(String revisionSuffix) {
        this.revisionSuffix = revisionSuffix;
        return this;
    }

    public Long terminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public Template withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    public List<InitContainer> initContainers() {
        return this.initContainers;
    }

    public Template withInitContainers(List<InitContainer> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public Template withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public Scale scale() {
        return this.scale;
    }

    public Template withScale(Scale scale) {
        this.scale = scale;
        return this;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public Template withVolumes(List<Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public List<ServiceBind> serviceBinds() {
        return this.serviceBinds;
    }

    public Template withServiceBinds(List<ServiceBind> serviceBinds) {
        this.serviceBinds = serviceBinds;
        return this;
    }

    public void validate() {
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.scale() != null) {
            this.scale().validate();
        }
        if (this.volumes() != null) {
            this.volumes().forEach(e -> e.validate());
        }
        if (this.serviceBinds() != null) {
            this.serviceBinds().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("revisionSuffix", this.revisionSuffix);
        jsonWriter.writeNumberField("terminationGracePeriodSeconds", (Number)this.terminationGracePeriodSeconds);
        jsonWriter.writeArrayField("initContainers", this.initContainers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("scale", (JsonSerializable)this.scale);
        jsonWriter.writeArrayField("volumes", this.volumes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("serviceBinds", this.serviceBinds, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Template fromJson(JsonReader jsonReader) throws IOException {
        return (Template)jsonReader.readObject(reader -> {
            Template deserializedTemplate = new Template();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("revisionSuffix".equals(fieldName)) {
                    deserializedTemplate.revisionSuffix = reader.getString();
                    continue;
                }
                if ("terminationGracePeriodSeconds".equals(fieldName)) {
                    deserializedTemplate.terminationGracePeriodSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("initContainers".equals(fieldName)) {
                    List initContainers;
                    deserializedTemplate.initContainers = initContainers = reader.readArray(reader1 -> InitContainer.fromJson(reader1));
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    List containers;
                    deserializedTemplate.containers = containers = reader.readArray(reader1 -> Container.fromJson(reader1));
                    continue;
                }
                if ("scale".equals(fieldName)) {
                    deserializedTemplate.scale = Scale.fromJson(reader);
                    continue;
                }
                if ("volumes".equals(fieldName)) {
                    List volumes;
                    deserializedTemplate.volumes = volumes = reader.readArray(reader1 -> Volume.fromJson(reader1));
                    continue;
                }
                if ("serviceBinds".equals(fieldName)) {
                    List serviceBinds;
                    deserializedTemplate.serviceBinds = serviceBinds = reader.readArray(reader1 -> ServiceBind.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTemplate;
        });
    }
}

