/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.OpenIdConnectClientCredential;
import com.azure.resourcemanager.appcontainers.models.OpenIdConnectConfig;
import java.io.IOException;

public final class OpenIdConnectRegistration
implements JsonSerializable<OpenIdConnectRegistration> {
    private String clientId;
    private OpenIdConnectClientCredential clientCredential;
    private OpenIdConnectConfig openIdConnectConfiguration;

    public String clientId() {
        return this.clientId;
    }

    public OpenIdConnectRegistration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OpenIdConnectClientCredential clientCredential() {
        return this.clientCredential;
    }

    public OpenIdConnectRegistration withClientCredential(OpenIdConnectClientCredential clientCredential) {
        this.clientCredential = clientCredential;
        return this;
    }

    public OpenIdConnectConfig openIdConnectConfiguration() {
        return this.openIdConnectConfiguration;
    }

    public OpenIdConnectRegistration withOpenIdConnectConfiguration(OpenIdConnectConfig openIdConnectConfiguration) {
        this.openIdConnectConfiguration = openIdConnectConfiguration;
        return this;
    }

    public void validate() {
        if (this.clientCredential() != null) {
            this.clientCredential().validate();
        }
        if (this.openIdConnectConfiguration() != null) {
            this.openIdConnectConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientCredential", (JsonSerializable)this.clientCredential);
        jsonWriter.writeJsonField("openIdConnectConfiguration", (JsonSerializable)this.openIdConnectConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static OpenIdConnectRegistration fromJson(JsonReader jsonReader) throws IOException {
        return (OpenIdConnectRegistration)jsonReader.readObject(reader -> {
            OpenIdConnectRegistration deserializedOpenIdConnectRegistration = new OpenIdConnectRegistration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientId".equals(fieldName)) {
                    deserializedOpenIdConnectRegistration.clientId = reader.getString();
                    continue;
                }
                if ("clientCredential".equals(fieldName)) {
                    deserializedOpenIdConnectRegistration.clientCredential = OpenIdConnectClientCredential.fromJson(reader);
                    continue;
                }
                if ("openIdConnectConfiguration".equals(fieldName)) {
                    deserializedOpenIdConnectRegistration.openIdConnectConfiguration = OpenIdConnectConfig.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenIdConnectRegistration;
        });
    }
}

