/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentInner;
import java.io.IOException;
import java.util.List;

public final class ManagedEnvironmentsCollection
implements JsonSerializable<ManagedEnvironmentsCollection> {
    private List<ManagedEnvironmentInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentsCollection.class);

    public List<ManagedEnvironmentInner> value() {
        return this.value;
    }

    public ManagedEnvironmentsCollection withValue(List<ManagedEnvironmentInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ManagedEnvironmentsCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedEnvironmentsCollection fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedEnvironmentsCollection)jsonReader.readObject(reader -> {
            ManagedEnvironmentsCollection deserializedManagedEnvironmentsCollection = new ManagedEnvironmentsCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedManagedEnvironmentsCollection.value = value = reader.readArray(reader1 -> ManagedEnvironmentInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedManagedEnvironmentsCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedEnvironmentsCollection;
        });
    }
}

