/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CertificateProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificateDomainControlValidation;
import java.io.IOException;

public final class ManagedCertificateProperties
implements JsonSerializable<ManagedCertificateProperties> {
    private CertificateProvisioningState provisioningState;
    private String subjectName;
    private String error;
    private ManagedCertificateDomainControlValidation domainControlValidation;
    private String validationToken;

    public CertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public ManagedCertificateProperties withSubjectName(String subjectName) {
        this.subjectName = subjectName;
        return this;
    }

    public String error() {
        return this.error;
    }

    public ManagedCertificateDomainControlValidation domainControlValidation() {
        return this.domainControlValidation;
    }

    public ManagedCertificateProperties withDomainControlValidation(ManagedCertificateDomainControlValidation domainControlValidation) {
        this.domainControlValidation = domainControlValidation;
        return this;
    }

    public String validationToken() {
        return this.validationToken;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subjectName", this.subjectName);
        jsonWriter.writeStringField("domainControlValidation", this.domainControlValidation == null ? null : this.domainControlValidation.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedCertificateProperties)jsonReader.readObject(reader -> {
            ManagedCertificateProperties deserializedManagedCertificateProperties = new ManagedCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedCertificateProperties.provisioningState = CertificateProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("subjectName".equals(fieldName)) {
                    deserializedManagedCertificateProperties.subjectName = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedManagedCertificateProperties.error = reader.getString();
                    continue;
                }
                if ("domainControlValidation".equals(fieldName)) {
                    deserializedManagedCertificateProperties.domainControlValidation = ManagedCertificateDomainControlValidation.fromString(reader.getString());
                    continue;
                }
                if ("validationToken".equals(fieldName)) {
                    deserializedManagedCertificateProperties.validationToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedCertificateProperties;
        });
    }
}

