/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ScaleRuleAuth;
import java.io.IOException;
import java.util.List;

public final class JobScaleRule
implements JsonSerializable<JobScaleRule> {
    private String name;
    private String type;
    private Object metadata;
    private List<ScaleRuleAuth> auth;
    private String identity;

    public String name() {
        return this.name;
    }

    public JobScaleRule withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public JobScaleRule withType(String type) {
        this.type = type;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public JobScaleRule withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ScaleRuleAuth> auth() {
        return this.auth;
    }

    public JobScaleRule withAuth(List<ScaleRuleAuth> auth) {
        this.auth = auth;
        return this;
    }

    public String identity() {
        return this.identity;
    }

    public JobScaleRule withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.auth() != null) {
            this.auth().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeArrayField("auth", this.auth, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static JobScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return (JobScaleRule)jsonReader.readObject(reader -> {
            JobScaleRule deserializedJobScaleRule = new JobScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedJobScaleRule.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobScaleRule.type = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedJobScaleRule.metadata = reader.readUntyped();
                    continue;
                }
                if ("auth".equals(fieldName)) {
                    List auth;
                    deserializedJobScaleRule.auth = auth = reader.readArray(reader1 -> ScaleRuleAuth.fromJson(reader1));
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedJobScaleRule.identity = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobScaleRule;
        });
    }
}

